/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import java.io.Closeable;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.curl.Main;
import okhttp3.curl.internal._MainCommonKt;
import okhttp3.curl.logging.LoggingUtil;
import okhttp3.internal.platform.Platform;
import okhttp3.logging.HttpLoggingInterceptor;
import okhttp3.logging.LoggingEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u00020\u000fJ\u0006\u0010B\u001a\u00020CJ\b\u0010D\u001a\u00020@H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\b\u001a\u0004\b\u0015\u0010\fR\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\b\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\b\u001a\u0004\b\u001d\u0010\u0006R#\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\b\u001a\u0004\b!\u0010\"R\u001d\u0010$\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\b\u001a\u0004\b%\u0010\u001aR\u001b\u0010'\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\b\u001a\u0004\b(\u0010\fR\u001d\u0010*\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\b\u001a\u0004\b+\u0010\u001aR\u001b\u0010-\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\b\u001a\u0004\b.\u0010\u0006R\u001b\u00100\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\b\u001a\u0004\b1\u0010\u0006R\u001b\u00103\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\b\u001a\u0004\b4\u0010\u0006R\u001d\u00106\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\b\u001a\u0004\b7\u0010\u001aR\u001b\u00109\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\b\u001a\u0004\b:\u0010\u001aR\u001b\u0010<\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\b\u001a\u0004\b=\u0010\u0006\u00a8\u0006F"}, d2={"Lokhttp3/curl/Main;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "allowInsecure", "", "getAllowInsecure", "()Z", "allowInsecure$delegate", "Lkotlin/properties/ReadOnlyProperty;", "callTimeout", "", "getCallTimeout", "()I", "callTimeout$delegate", "client", "Lokhttp3/Call$Factory;", "getClient", "()Lokhttp3/Call$Factory;", "setClient", "(Lokhttp3/Call$Factory;)V", "connectTimeout", "getConnectTimeout", "connectTimeout$delegate", "data", "", "getData", "()Ljava/lang/String;", "data$delegate", "followRedirects", "getFollowRedirects", "followRedirects$delegate", "headers", "", "getHeaders", "()Ljava/util/List;", "headers$delegate", "method", "getMethod", "method$delegate", "readTimeout", "getReadTimeout", "readTimeout$delegate", "referer", "getReferer", "referer$delegate", "showHeaders", "getShowHeaders", "showHeaders$delegate", "showHttp2Frames", "getShowHttp2Frames", "showHttp2Frames$delegate", "sslDebug", "getSslDebug", "sslDebug$delegate", "url", "getUrl", "url$delegate", "userAgent", "getUserAgent", "userAgent$delegate", "verbose", "getVerbose", "verbose$delegate", "close", "", "createClient", "createRequest", "Lokhttp3/Request;", "run", "Companion", "okcurl"})
public final class Main
extends CliktCommand {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty method$delegate;
    @NotNull
    private final ReadOnlyProperty data$delegate;
    @NotNull
    private final ReadOnlyProperty headers$delegate;
    @NotNull
    private final ReadOnlyProperty userAgent$delegate;
    @NotNull
    private final ReadOnlyProperty connectTimeout$delegate;
    @NotNull
    private final ReadOnlyProperty readTimeout$delegate;
    @NotNull
    private final ReadOnlyProperty callTimeout$delegate;
    @NotNull
    private final ReadOnlyProperty followRedirects$delegate;
    @NotNull
    private final ReadOnlyProperty allowInsecure$delegate;
    @NotNull
    private final ReadOnlyProperty showHeaders$delegate;
    @NotNull
    private final ReadOnlyProperty showHttp2Frames$delegate;
    @NotNull
    private final ReadOnlyProperty referer$delegate;
    @NotNull
    private final ReadOnlyProperty verbose$delegate;
    @NotNull
    private final ReadOnlyProperty sslDebug$delegate;
    @NotNull
    private final ReadOnlyProperty url$delegate;
    @Nullable
    private Call.Factory client;
    @NotNull
    public static final String NAME = "okcurl";
    public static final int DEFAULT_TIMEOUT = -1;

    public Main() {
        super("A curl for the next-generation web.", null, NAME, false, false, null, null, false, false, false, 1018, null);
        String[] stringArray = new String[]{"-X", "--request"};
        this.method$delegate = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Specify request command to use", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        stringArray = new String[]{"-d", "--data"};
        this.data$delegate = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"HTTP POST data", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        stringArray = new String[]{"-H", "--header"};
        this.headers$delegate = OptionWithValuesKt.multiple$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Custom header to pass to server", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), null, (boolean)false, (int)3, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
        stringArray = new String[]{"-A", "--user-agent"};
        this.userAgent$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"User-Agent to send to server", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (Object)("okcurl/" + Main.Companion.versionString()), null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
        stringArray = new String[]{"--connect-timeout"};
        this.connectTimeout$delegate = OptionWithValuesKt.default$default((OptionWithValues)IntKt.int$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Maximum time allowed for connection (seconds)", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (boolean)false, (int)1, null), (Object)-1, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[4]);
        stringArray = new String[]{"--read-timeout"};
        this.readTimeout$delegate = OptionWithValuesKt.default$default((OptionWithValues)IntKt.int$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Maximum time allowed for reading data (seconds)", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (boolean)false, (int)1, null), (Object)-1, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[5]);
        stringArray = new String[]{"--call-timeout"};
        this.callTimeout$delegate = OptionWithValuesKt.default$default((OptionWithValues)IntKt.int$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Maximum time allowed for the entire call (seconds)", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (boolean)false, (int)1, null), (Object)-1, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[6]);
        stringArray = new String[]{"-L", "--location"};
        this.followRedirects$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Follow redirects", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[7]);
        stringArray = new String[]{"-k", "--insecure"};
        this.allowInsecure$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Allow connections to SSL sites without certs", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[8]);
        stringArray = new String[]{"-i", "--include"};
        this.showHeaders$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Include protocol headers in the output", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[9]);
        stringArray = new String[]{"--frames"};
        this.showHttp2Frames$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Log HTTP/2 frames to STDERR", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[10]);
        stringArray = new String[]{"-e", "--referer"};
        this.referer$delegate = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Referer URL", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[11]);
        stringArray = new String[]{"-v", "--verbose"};
        this.verbose$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Makes okcurl verbose during the operation", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[12]);
        this.sslDebug$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])new String[0], (String)"Output SSL Debug", null, (boolean)false, null, null, null, null, (boolean)false, (int)508, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[13]);
        this.url$delegate = (ReadOnlyProperty)ArgumentKt.argument$default((CliktCommand)this, (String)"url", (String)"Remote resource URL", null, null, (int)12, null).provideDelegate((Object)this, $$delegatedProperties[14]);
    }

    @Nullable
    public final String getMethod() {
        return (String)this.method$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public final String getData() {
        return (String)this.data$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Nullable
    public final List<String> getHeaders() {
        return (List)this.headers$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final String getUserAgent() {
        return (String)this.userAgent$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final int getConnectTimeout() {
        return ((Number)this.connectTimeout$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    public final int getReadTimeout() {
        return ((Number)this.readTimeout$delegate.getValue((Object)this, $$delegatedProperties[5])).intValue();
    }

    public final int getCallTimeout() {
        return ((Number)this.callTimeout$delegate.getValue((Object)this, $$delegatedProperties[6])).intValue();
    }

    public final boolean getFollowRedirects() {
        return (Boolean)this.followRedirects$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    public final boolean getAllowInsecure() {
        return (Boolean)this.allowInsecure$delegate.getValue((Object)this, $$delegatedProperties[8]);
    }

    public final boolean getShowHeaders() {
        return (Boolean)this.showHeaders$delegate.getValue((Object)this, $$delegatedProperties[9]);
    }

    public final boolean getShowHttp2Frames() {
        return (Boolean)this.showHttp2Frames$delegate.getValue((Object)this, $$delegatedProperties[10]);
    }

    @Nullable
    public final String getReferer() {
        return (String)this.referer$delegate.getValue((Object)this, $$delegatedProperties[11]);
    }

    public final boolean getVerbose() {
        return (Boolean)this.verbose$delegate.getValue((Object)this, $$delegatedProperties[12]);
    }

    public final boolean getSslDebug() {
        return (Boolean)this.sslDebug$delegate.getValue((Object)this, $$delegatedProperties[13]);
    }

    @Nullable
    public final String getUrl() {
        return (String)this.url$delegate.getValue((Object)this, $$delegatedProperties[14]);
    }

    @Nullable
    public final Call.Factory getClient() {
        return this.client;
    }

    public final void setClient(@Nullable Call.Factory factory) {
        this.client = factory;
    }

    public void run() {
        LoggingUtil.Companion.configureLogging(this.getVerbose(), this.getShowHttp2Frames(), this.getSslDebug());
        _MainCommonKt.commonRun(this);
    }

    @NotNull
    public final Request createRequest() {
        return _MainCommonKt.commonCreateRequest(this);
    }

    @NotNull
    public final Call.Factory createClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followSslRedirects(this.getFollowRedirects());
        if (this.getConnectTimeout() != -1) {
            builder.connectTimeout((long)this.getConnectTimeout(), TimeUnit.SECONDS);
        }
        if (this.getReadTimeout() != -1) {
            builder.readTimeout((long)this.getReadTimeout(), TimeUnit.SECONDS);
        }
        if (this.getCallTimeout() != -1) {
            builder.callTimeout((long)this.getCallTimeout(), TimeUnit.SECONDS);
        }
        if (this.getAllowInsecure()) {
            X509TrustManager trustManager = Main.Companion.createInsecureTrustManager();
            SSLSocketFactory sslSocketFactory = Main.Companion.createInsecureSslSocketFactory(trustManager);
            builder.sslSocketFactory(sslSocketFactory, trustManager);
            builder.hostnameVerifier(Main.Companion.createInsecureHostnameVerifier());
        }
        if (this.getVerbose()) {
            HttpLoggingInterceptor.Logger logger2 = createClient.logger.1.INSTANCE;
            builder.eventListenerFactory((EventListener.Factory)new LoggingEventListener.Factory(logger2));
        }
        return (Call.Factory)builder.build();
    }

    public final void close() {
        Call.Factory factory = this.client;
        Intrinsics.checkNotNull((Object)factory, (String)"null cannot be cast to non-null type okhttp3.OkHttpClient");
        OkHttpClient okHttpClient = (OkHttpClient)factory;
        okHttpClient.connectionPool().evictAll();
        okHttpClient.dispatcher().executorService().shutdownNow();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "method", "getMethod()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "data", "getData()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "headers", "getHeaders()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "userAgent", "getUserAgent()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "connectTimeout", "getConnectTimeout()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "readTimeout", "getReadTimeout()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "callTimeout", "getCallTimeout()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "followRedirects", "getFollowRedirects()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "allowInsecure", "getAllowInsecure()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "showHeaders", "getShowHeaders()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "showHttp2Frames", "getShowHttp2Frames()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "referer", "getReferer()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "verbose", "getVerbose()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "sslDebug", "getSslDebug()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Main.class, "url", "getUrl()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/curl/Main$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "NAME", "", "createInsecureHostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "createInsecureSslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "trustManager", "Ljavax/net/ssl/TrustManager;", "createInsecureTrustManager", "Ljavax/net/ssl/X509TrustManager;", "versionString", "okcurl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String versionString() {
            Properties prop = new Properties();
            InputStream inputStream = Main.class.getResourceAsStream("/okcurl-version.properties");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    prop.load(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return prop.getProperty("version", "dev");
        }

        private final X509TrustManager createInsecureTrustManager() {
            return new X509TrustManager(){

                public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                }

                public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                    Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                    Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                }

                @NotNull
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
        }

        private final SSLSocketFactory createInsecureSslSocketFactory(TrustManager trustManager) {
            SSLContext sSLContext;
            SSLContext $this$createInsecureSslSocketFactory_u24lambda_u241 = sSLContext = Platform.Companion.get().newSSLContext();
            boolean bl = false;
            TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
            $this$createInsecureSslSocketFactory_u24lambda_u241.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSocketFactory(...)");
            return sSLSocketFactory;
        }

        private final HostnameVerifier createInsecureHostnameVerifier() {
            return Companion::createInsecureHostnameVerifier$lambda$2;
        }

        private static final boolean createInsecureHostnameVerifier$lambda$2(String string, SSLSession sSLSession) {
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

