/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.huc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SecureCacheResponse;
import java.net.URI;
import java.net.URLConnection;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Internal;
import okhttp3.internal.JavaNetHeaders;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.huc.DelegatingHttpsURLConnection;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class JavaApiConverter {
    private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
    private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";

    private JavaApiConverter() {
    }

    public static Response createOkResponseForCachePut(URI uri, URLConnection urlConnection) throws IOException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)urlConnection;
        Response.Builder okResponseBuilder = new Response.Builder();
        Headers responseHeaders = JavaApiConverter.createHeaders(urlConnection.getHeaderFields());
        Headers varyHeaders = JavaApiConverter.varyHeaders(urlConnection, responseHeaders);
        if (varyHeaders == null) {
            return null;
        }
        String requestMethod = httpUrlConnection.getRequestMethod();
        RequestBody placeholderBody = HttpMethod.requiresRequestBody((String)requestMethod) ? Util.EMPTY_REQUEST : null;
        Request okRequest = new Request.Builder().url(uri.toString()).method(requestMethod, placeholderBody).headers(varyHeaders).build();
        okResponseBuilder.request(okRequest);
        StatusLine statusLine = StatusLine.parse((String)JavaApiConverter.extractStatusLine(httpUrlConnection));
        okResponseBuilder.protocol(statusLine.protocol);
        okResponseBuilder.code(statusLine.code);
        okResponseBuilder.message(statusLine.message);
        Response networkResponse = okResponseBuilder.build();
        okResponseBuilder.networkResponse(networkResponse);
        Headers okHeaders = JavaApiConverter.extractOkResponseHeaders(httpUrlConnection, okResponseBuilder);
        okResponseBuilder.headers(okHeaders);
        ResponseBody okBody = JavaApiConverter.createOkBody(urlConnection);
        okResponseBuilder.body(okBody);
        if (httpUrlConnection instanceof HttpsURLConnection) {
            Certificate[] peerCertificates;
            HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)httpUrlConnection;
            try {
                peerCertificates = httpsUrlConnection.getServerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = null;
            }
            Certificate[] localCertificates = httpsUrlConnection.getLocalCertificates();
            String cipherSuiteString = httpsUrlConnection.getCipherSuite();
            CipherSuite cipherSuite = CipherSuite.forJavaName((String)cipherSuiteString);
            Handshake handshake = Handshake.get((TlsVersion)TlsVersion.SSL_3_0, (CipherSuite)cipherSuite, JavaApiConverter.nullSafeImmutableList(peerCertificates), JavaApiConverter.nullSafeImmutableList(localCertificates));
            okResponseBuilder.handshake(handshake);
        }
        return okResponseBuilder.build();
    }

    private static Headers createHeaders(Map<String, List<String>> headers) {
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (header.getKey() == null || header.getValue() == null) continue;
            String name = header.getKey().trim();
            for (String value : header.getValue()) {
                String trimmedValue = value.trim();
                Internal.instance.addLenient(builder, name, trimmedValue);
            }
        }
        return builder.build();
    }

    private static Headers varyHeaders(URLConnection urlConnection, Headers responseHeaders) {
        if (HttpHeaders.hasVaryAll((Headers)responseHeaders)) {
            return null;
        }
        Set varyFields = HttpHeaders.varyFields((Headers)responseHeaders);
        if (varyFields.isEmpty()) {
            return Util.EMPTY_HEADERS;
        }
        if (!(urlConnection instanceof CacheHttpURLConnection) && !(urlConnection instanceof CacheHttpsURLConnection)) {
            return null;
        }
        Map<String, List<String>> requestProperties = urlConnection.getRequestProperties();
        Headers.Builder result = new Headers.Builder();
        for (String fieldName : varyFields) {
            List<String> fieldValues = requestProperties.get(fieldName);
            if (fieldValues == null) {
                if (!fieldName.equals("Accept-Encoding")) continue;
                result.add("Accept-Encoding", "gzip");
                continue;
            }
            for (String fieldValue : fieldValues) {
                Internal.instance.addLenient(result, fieldName, fieldValue);
            }
        }
        return result.build();
    }

    static Response createOkResponseForCacheGet(Request request, CacheResponse javaResponse) throws IOException {
        Headers responseHeaders = JavaApiConverter.createHeaders(javaResponse.getHeaders());
        Headers varyHeaders = HttpHeaders.hasVaryAll((Headers)responseHeaders) ? Util.EMPTY_HEADERS : HttpHeaders.varyHeaders((Headers)request.headers(), (Headers)responseHeaders);
        Request cacheRequest = new Request.Builder().url(request.url()).method(request.method(), null).headers(varyHeaders).build();
        Response.Builder okResponseBuilder = new Response.Builder();
        okResponseBuilder.request(cacheRequest);
        StatusLine statusLine = StatusLine.parse((String)JavaApiConverter.extractStatusLine(javaResponse));
        okResponseBuilder.protocol(statusLine.protocol);
        okResponseBuilder.code(statusLine.code);
        okResponseBuilder.message(statusLine.message);
        Headers okHeaders = JavaApiConverter.extractOkHeaders(javaResponse, okResponseBuilder);
        okResponseBuilder.headers(okHeaders);
        ResponseBody okBody = JavaApiConverter.createOkBody(okHeaders, javaResponse);
        okResponseBuilder.body(okBody);
        if (javaResponse instanceof SecureCacheResponse) {
            List<Certificate> peerCertificates;
            SecureCacheResponse javaSecureCacheResponse = (SecureCacheResponse)javaResponse;
            try {
                peerCertificates = javaSecureCacheResponse.getServerCertificateChain();
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = Collections.emptyList();
            }
            List<Certificate> localCertificates = javaSecureCacheResponse.getLocalCertificateChain();
            if (localCertificates == null) {
                localCertificates = Collections.emptyList();
            }
            String cipherSuiteString = javaSecureCacheResponse.getCipherSuite();
            CipherSuite cipherSuite = CipherSuite.forJavaName((String)cipherSuiteString);
            Handshake handshake = Handshake.get((TlsVersion)TlsVersion.SSL_3_0, (CipherSuite)cipherSuite, peerCertificates, localCertificates);
            okResponseBuilder.handshake(handshake);
        }
        return okResponseBuilder.build();
    }

    public static Request createOkRequest(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) {
        RequestBody placeholderBody = HttpMethod.requiresRequestBody((String)requestMethod) ? Util.EMPTY_REQUEST : null;
        Request.Builder builder = new Request.Builder().url(uri.toString()).method(requestMethod, placeholderBody);
        if (requestHeaders != null) {
            Headers headers = JavaApiConverter.extractOkHeaders(requestHeaders, null);
            builder.headers(headers);
        }
        return builder.build();
    }

    public static CacheResponse createJavaCacheResponse(final Response response) {
        final Headers headers = JavaApiConverter.withSyntheticHeaders(response);
        final ResponseBody body = response.body();
        if (response.request().isHttps()) {
            final Handshake handshake = response.handshake();
            return new SecureCacheResponse(){

                @Override
                public String getCipherSuite() {
                    return handshake != null ? handshake.cipherSuite().javaName() : null;
                }

                @Override
                public List<Certificate> getLocalCertificateChain() {
                    if (handshake == null) {
                        return null;
                    }
                    List certificates = handshake.localCertificates();
                    return certificates.size() > 0 ? certificates : null;
                }

                @Override
                public List<Certificate> getServerCertificateChain() throws SSLPeerUnverifiedException {
                    if (handshake == null) {
                        return null;
                    }
                    List certificates = handshake.peerCertificates();
                    return certificates.size() > 0 ? certificates : null;
                }

                @Override
                public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                    if (handshake == null) {
                        return null;
                    }
                    return handshake.peerPrincipal();
                }

                @Override
                public Principal getLocalPrincipal() {
                    if (handshake == null) {
                        return null;
                    }
                    return handshake.localPrincipal();
                }

                @Override
                public Map<String, List<String>> getHeaders() throws IOException {
                    return JavaNetHeaders.toMultimap((Headers)headers, (String)StatusLine.get((Response)response).toString());
                }

                @Override
                public InputStream getBody() throws IOException {
                    if (body == null) {
                        return null;
                    }
                    return body.byteStream();
                }
            };
        }
        return new CacheResponse(){

            @Override
            public Map<String, List<String>> getHeaders() throws IOException {
                return JavaNetHeaders.toMultimap((Headers)headers, (String)StatusLine.get((Response)response).toString());
            }

            @Override
            public InputStream getBody() throws IOException {
                if (body == null) {
                    return null;
                }
                return body.byteStream();
            }
        };
    }

    public static CacheRequest createJavaCacheRequest(final okhttp3.internal.cache.CacheRequest okCacheRequest) {
        return new CacheRequest(){

            @Override
            public void abort() {
                okCacheRequest.abort();
            }

            @Override
            public OutputStream getBody() throws IOException {
                Sink body = okCacheRequest.body();
                if (body == null) {
                    return null;
                }
                return Okio.buffer((Sink)body).outputStream();
            }
        };
    }

    static HttpURLConnection createJavaUrlConnectionForCachePut(Response okResponse) {
        Request request = (okResponse = okResponse.newBuilder().body(null).headers(JavaApiConverter.withSyntheticHeaders(okResponse)).build()).request();
        if (request.isHttps()) {
            return new CacheHttpsURLConnection(new CacheHttpURLConnection(okResponse));
        }
        return new CacheHttpURLConnection(okResponse);
    }

    private static Headers withSyntheticHeaders(Response okResponse) {
        return okResponse.headers().newBuilder().add(SENT_MILLIS, Long.toString(okResponse.sentRequestAtMillis())).add(RECEIVED_MILLIS, Long.toString(okResponse.receivedResponseAtMillis())).build();
    }

    static Map<String, List<String>> extractJavaHeaders(Request request) {
        return JavaNetHeaders.toMultimap((Headers)request.headers(), null);
    }

    private static Headers extractOkHeaders(CacheResponse javaResponse, Response.Builder okResponseBuilder) throws IOException {
        Map<String, List<String>> javaResponseHeaders = javaResponse.getHeaders();
        return JavaApiConverter.extractOkHeaders(javaResponseHeaders, okResponseBuilder);
    }

    private static Headers extractOkResponseHeaders(HttpURLConnection httpUrlConnection, Response.Builder okResponseBuilder) {
        Map<String, List<String>> javaResponseHeaders = httpUrlConnection.getHeaderFields();
        return JavaApiConverter.extractOkHeaders(javaResponseHeaders, okResponseBuilder);
    }

    static Headers extractOkHeaders(Map<String, List<String>> javaHeaders, Response.Builder okResponseBuilder) {
        Headers.Builder okHeadersBuilder = new Headers.Builder();
        for (Map.Entry<String, List<String>> javaHeader : javaHeaders.entrySet()) {
            String name = javaHeader.getKey();
            if (name == null) continue;
            if (okResponseBuilder != null && javaHeader.getValue().size() == 1) {
                if (name.equals(SENT_MILLIS)) {
                    okResponseBuilder.sentRequestAtMillis(Long.valueOf(javaHeader.getValue().get(0)).longValue());
                    continue;
                }
                if (name.equals(RECEIVED_MILLIS)) {
                    okResponseBuilder.receivedResponseAtMillis(Long.valueOf(javaHeader.getValue().get(0)).longValue());
                    continue;
                }
            }
            for (String value : javaHeader.getValue()) {
                Internal.instance.addLenient(okHeadersBuilder, name, value);
            }
        }
        return okHeadersBuilder.build();
    }

    private static String extractStatusLine(HttpURLConnection httpUrlConnection) {
        return httpUrlConnection.getHeaderField(null);
    }

    private static String extractStatusLine(CacheResponse javaResponse) throws IOException {
        Map<String, List<String>> javaResponseHeaders = javaResponse.getHeaders();
        return JavaApiConverter.extractStatusLine(javaResponseHeaders);
    }

    static String extractStatusLine(Map<String, List<String>> javaResponseHeaders) throws ProtocolException {
        List<String> values = javaResponseHeaders.get(null);
        if (values == null || values.size() == 0) {
            throw new ProtocolException("CacheResponse is missing a 'null' header containing the status line. Headers=" + javaResponseHeaders);
        }
        return values.get(0);
    }

    private static ResponseBody createOkBody(final Headers okHeaders, CacheResponse cacheResponse) throws IOException {
        final BufferedSource body = Okio.buffer((Source)Okio.source((InputStream)cacheResponse.getBody()));
        return new ResponseBody(){

            public MediaType contentType() {
                String contentTypeHeader = okHeaders.get("Content-Type");
                return contentTypeHeader == null ? null : MediaType.parse((String)contentTypeHeader);
            }

            public long contentLength() {
                return HttpHeaders.contentLength((Headers)okHeaders);
            }

            public BufferedSource source() {
                return body;
            }
        };
    }

    private static ResponseBody createOkBody(final URLConnection urlConnection) throws IOException {
        if (!urlConnection.getDoInput()) {
            return null;
        }
        final BufferedSource body = Okio.buffer((Source)Okio.source((InputStream)urlConnection.getInputStream()));
        return new ResponseBody(){

            public MediaType contentType() {
                String contentTypeHeader = urlConnection.getContentType();
                return contentTypeHeader == null ? null : MediaType.parse((String)contentTypeHeader);
            }

            public long contentLength() {
                String s = urlConnection.getHeaderField("Content-Length");
                return JavaApiConverter.stringToLong(s);
            }

            public BufferedSource source() {
                return body;
            }
        };
    }

    private static RuntimeException throwRequestModificationException() {
        throw new UnsupportedOperationException("ResponseCache cannot modify the request.");
    }

    private static RuntimeException throwRequestHeaderAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access request headers");
    }

    private static RuntimeException throwRequestSslAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access SSL internals");
    }

    private static RuntimeException throwResponseBodyAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access the response body.");
    }

    private static <T> List<T> nullSafeImmutableList(T[] elements) {
        return elements == null ? Collections.emptyList() : Util.immutableList((Object[])elements);
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static final class CacheHttpsURLConnection
    extends DelegatingHttpsURLConnection {
        private final CacheHttpURLConnection delegate;

        CacheHttpsURLConnection(CacheHttpURLConnection delegate) {
            super((HttpURLConnection)delegate);
            this.delegate = delegate;
        }

        protected Handshake handshake() {
            return this.delegate.response.handshake();
        }

        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        public HostnameVerifier getHostnameVerifier() {
            throw JavaApiConverter.throwRequestSslAccessException();
        }

        public void setSSLSocketFactory(SSLSocketFactory socketFactory) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        public SSLSocketFactory getSSLSocketFactory() {
            throw JavaApiConverter.throwRequestSslAccessException();
        }
    }

    private static final class CacheHttpURLConnection
    extends HttpURLConnection {
        private final Request request;
        private final Response response;

        CacheHttpURLConnection(Response response) {
            super(response.request().url().url());
            this.request = response.request();
            this.response = response;
            this.connected = true;
            this.doOutput = this.request.body() != null;
            this.doInput = true;
            this.useCaches = true;
            this.method = this.request.method();
        }

        @Override
        public void connect() throws IOException {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void disconnect() {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void setRequestProperty(String key, String value) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void addRequestProperty(String key, String value) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public String getRequestProperty(String key) {
            return this.request.header(key);
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return JavaNetHeaders.toMultimap((Headers)this.request.headers(), null);
        }

        @Override
        public void setFixedLengthStreamingMode(int contentLength) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void setFixedLengthStreamingMode(long contentLength) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void setChunkedStreamingMode(int chunklen) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void setInstanceFollowRedirects(boolean followRedirects) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return super.getInstanceFollowRedirects();
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public String getRequestMethod() {
            return this.request.method();
        }

        @Override
        public String getHeaderFieldKey(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Invalid header index: " + position);
            }
            if (position == 0 || position > this.response.headers().size()) {
                return null;
            }
            return this.response.headers().name(position - 1);
        }

        @Override
        public String getHeaderField(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Invalid header index: " + position);
            }
            if (position == 0) {
                return StatusLine.get((Response)this.response).toString();
            }
            if (position > this.response.headers().size()) {
                return null;
            }
            return this.response.headers().value(position - 1);
        }

        @Override
        public String getHeaderField(String fieldName) {
            return fieldName == null ? StatusLine.get((Response)this.response).toString() : this.response.headers().get(fieldName);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return JavaNetHeaders.toMultimap((Headers)this.response.headers(), (String)StatusLine.get((Response)this.response).toString());
        }

        @Override
        public int getResponseCode() throws IOException {
            return this.response.code();
        }

        @Override
        public String getResponseMessage() throws IOException {
            return this.response.message();
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void setConnectTimeout(int timeout) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public int getConnectTimeout() {
            return 0;
        }

        @Override
        public void setReadTimeout(int timeout) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public int getReadTimeout() {
            return 0;
        }

        @Override
        public Object getContent() throws IOException {
            throw JavaApiConverter.throwResponseBodyAccessException();
        }

        public Object getContent(Class[] classes) throws IOException {
            throw JavaApiConverter.throwResponseBodyAccessException();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    throw JavaApiConverter.throwResponseBodyAccessException();
                }
            };
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public void setDoInput(boolean doInput) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public boolean getDoInput() {
            return this.doInput;
        }

        @Override
        public void setDoOutput(boolean doOutput) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public boolean getDoOutput() {
            return this.doOutput;
        }

        @Override
        public void setAllowUserInteraction(boolean allowUserInteraction) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public boolean getAllowUserInteraction() {
            return false;
        }

        @Override
        public void setUseCaches(boolean useCaches) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public boolean getUseCaches() {
            return super.getUseCaches();
        }

        @Override
        public void setIfModifiedSince(long ifModifiedSince) {
            throw JavaApiConverter.throwRequestModificationException();
        }

        @Override
        public long getIfModifiedSince() {
            return JavaApiConverter.stringToLong(this.request.headers().get("If-Modified-Since"));
        }

        @Override
        public boolean getDefaultUseCaches() {
            return super.getDefaultUseCaches();
        }

        @Override
        public void setDefaultUseCaches(boolean defaultUseCaches) {
            super.setDefaultUseCaches(defaultUseCaches);
        }
    }
}

