/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import org.conscrypt.Conscrypt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lokhttp3/internal/platform/android/ConscryptSocketAdapter;", "Lokhttp3/internal/platform/android/SocketAdapter;", "<init>", "()V", "matchesSocket", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "isSupported", "getSelectedProtocol", "", "configureTlsExtensions", "", "hostname", "protocols", "", "Lokhttp3/Protocol;", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nConscryptSocketAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConscryptSocketAdapter.kt\nokhttp3/internal/platform/android/ConscryptSocketAdapter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n37#2,2:98\n*S KotlinDebug\n*F\n+ 1 ConscryptSocketAdapter.kt\nokhttp3/internal/platform/android/ConscryptSocketAdapter\n*L\n50#1:98,2\n*E\n"})
public final class ConscryptSocketAdapter
implements SocketAdapter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final DeferredSocketAdapter.Factory factory;
    private static final boolean isSupported;

    @Override
    public boolean matchesSocket(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        return Conscrypt.isConscrypt((SSLSocket)sslSocket);
    }

    @Override
    public boolean isSupported() {
        return isSupported;
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        return this.matchesSocket(sslSocket) ? Conscrypt.getApplicationProtocol((SSLSocket)sslSocket) : null;
    }

    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        if (this.matchesSocket(sslSocket)) {
            Conscrypt.setUseSessionTickets((SSLSocket)sslSocket, (boolean)true);
            List<String> names = Platform.Companion.alpnProtocolNames(protocols);
            Collection $this$toTypedArray$iv = names;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Conscrypt.setApplicationProtocols((SSLSocket)sslSocket, (String[])thisCollection$iv.toArray(new String[0]));
        }
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        factory = new DeferredSocketAdapter.Factory(){

            public boolean matchesSocket(SSLSocket sslSocket) {
                Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
                return ConscryptSocketAdapter.Companion.isSupported() && Conscrypt.isConscrypt((SSLSocket)sslSocket);
            }

            public SocketAdapter create(SSLSocket sslSocket) {
                Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
                return new ConscryptSocketAdapter();
            }
        };
        try {
            Class.forName("org.conscrypt.Conscrypt$Version", false, Companion.getClass().getClassLoader());
            bl = Conscrypt.isAvailable() && Companion.atLeastVersion(2, 1, 0);
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        isSupported = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/platform/android/ConscryptSocketAdapter$Companion;", "", "<init>", "()V", "factory", "Lokhttp3/internal/platform/android/DeferredSocketAdapter$Factory;", "getFactory", "()Lokhttp3/internal/platform/android/DeferredSocketAdapter$Factory;", "isSupported", "", "()Z", "atLeastVersion", "major", "", "minor", "patch", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeferredSocketAdapter.Factory getFactory() {
            return factory;
        }

        public final boolean isSupported() {
            return isSupported;
        }

        public final boolean atLeastVersion(int major, int minor, int patch) {
            Conscrypt.Version version = Conscrypt.version();
            if (version == null) {
                return false;
            }
            Conscrypt.Version conscryptVersion = version;
            if (conscryptVersion.major() != major) {
                return conscryptVersion.major() > major;
            }
            if (conscryptVersion.minor() != minor) {
                return conscryptVersion.minor() > minor;
            }
            return conscryptVersion.patch() >= patch;
        }

        public static /* synthetic */ boolean atLeastVersion$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.atLeastVersion(n, n2, n3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

