//[okhttp](../../../index.md)/[okhttp3](../index.md)/[OkHttpClient](index.md)

# OkHttpClient

[jvm]\
open class [OkHttpClient](index.md) : [Call.Factory](../-call/-factory/index.md), [WebSocket.Factory](../-web-socket/-factory/index.md)

Factory for [calls](../-call/index.md), which can be used to send HTTP requests and read their responses.

##  OkHttpClients Should Be Shared

OkHttp performs best when you create a single OkHttpClient instance and reuse it for all of your HTTP calls. This is because each client holds its own connection pool and thread pools. Reusing connections and threads reduces latency and saves memory. Conversely, creating a client for each request wastes resources on idle pools.

Use new OkHttpClient() to create a shared instance with the default settings:

// The singleton HTTP client.\
public final OkHttpClient client = new OkHttpClient();

Or use new OkHttpClient.Builder() to create a shared instance with custom settings:

// The singleton HTTP client.\
public final OkHttpClient client = new OkHttpClient.Builder()\
    .addInterceptor(new HttpLoggingInterceptor())\
    .cache(new Cache(cacheDir, cacheSize))\
    .build();

##  Customize Your Client With newBuilder()

You can customize a shared OkHttpClient instance with [newBuilder](new-builder.md). This builds a client that shares the same connection pool, thread pools, and configuration. Use the builder methods to add configuration to the derived client for a specific purpose.

This example shows the single instance with default configurations.

public final OkHttpClient client = new OkHttpClient.Builder()\
    .readTimeout(1000, TimeUnit.MILLISECONDS)\
    .writeTimeout(1000, TimeUnit.MILLISECONDS)\
    .build();

This example shows a call with a short 500 millisecond read timeout and a 1000 millisecond write timeout. Original configuration is kept, but can be overriden.

OkHttpClient eagerClient = client.newBuilder()\
    .readTimeout(500, TimeUnit.MILLISECONDS)\
    .build();\
Response response = eagerClient.newCall(request).execute();

##  Shutdown Isn't Necessary

The threads and connections that are held will be released automatically if they remain idle. But if you are writing a application that needs to aggressively release unused resources you may do so.

Shutdown the dispatcher's executor service with [shutdown()](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/ExecutorService.html#shutdown--). This will also cause future calls to the client to be rejected.

client.dispatcher().executorService().shutdown();

Clear the connection pool with [evictAll()](../-connection-pool/evict-all.md). Note that the connection pool's daemon thread may not exit immediately.

client.connectionPool().evictAll();

If your client has a cache, call [close()](../-cache/close.md). Note that it is an error to create calls against a cache that is closed, and doing so will cause the call to crash.

client.cache().close();

OkHttp also uses daemon threads for HTTP/2 connections. These will exit automatically if they remain idle.

## Constructors

| | |
|---|---|
| [OkHttpClient](-ok-http-client.md) | [jvm]<br>fun [OkHttpClient](-ok-http-client.md)() |

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [newBuilder](new-builder.md) | [jvm]<br>open fun [newBuilder](new-builder.md)(): [OkHttpClient.Builder](-builder/index.md) |
| [newCall](new-call.md) | [jvm]<br>open override fun [newCall](new-call.md)(request: [Request](../-request/index.md)): [Call](../-call/index.md)<br>Prepares the [request](new-call.md) to be executed at some point in the future. |
| [newWebSocket](new-web-socket.md) | [jvm]<br>open override fun [newWebSocket](new-web-socket.md)(request: [Request](../-request/index.md), listener: [WebSocketListener](../-web-socket-listener/index.md)): [WebSocket](../-web-socket/index.md)<br>Uses [request](new-web-socket.md) to connect a new web socket. |

## Properties

| Name | Summary |
|---|---|
| [authenticator](authenticator.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;authenticator&quot;)<br>val [authenticator](authenticator.md): [Authenticator](../-authenticator/index.md) |
| [cache](cache.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;cache&quot;)<br>val [cache](cache.md): [Cache](../-cache/index.md)? |
| [callTimeoutMillis](call-timeout-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;callTimeoutMillis&quot;)<br>val [callTimeoutMillis](call-timeout-millis.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Default call timeout (in milliseconds). By default there is no timeout for complete calls, but there is for the connect, write, and read actions within a call. |
| [certificateChainCleaner](certificate-chain-cleaner.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;certificateChainCleaner&quot;)<br>val [certificateChainCleaner](certificate-chain-cleaner.md): CertificateChainCleaner? |
| [certificatePinner](certificate-pinner.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;certificatePinner&quot;)<br>val [certificatePinner](certificate-pinner.md): [CertificatePinner](../-certificate-pinner/index.md) |
| [connectionPool](connection-pool.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;connectionPool&quot;)<br>val [connectionPool](connection-pool.md): [ConnectionPool](../-connection-pool/index.md) |
| [connectionSpecs](connection-specs.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;connectionSpecs&quot;)<br>val [connectionSpecs](connection-specs.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ConnectionSpec](../-connection-spec/index.md)&gt; |
| [connectTimeoutMillis](connect-timeout-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;connectTimeoutMillis&quot;)<br>val [connectTimeoutMillis](connect-timeout-millis.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Default connect timeout (in milliseconds). The default is 10 seconds. |
| [cookieJar](cookie-jar.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;cookieJar&quot;)<br>val [cookieJar](cookie-jar.md): [CookieJar](../-cookie-jar/index.md) |
| [dispatcher](dispatcher.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;dispatcher&quot;)<br>val [dispatcher](dispatcher.md): [Dispatcher](../-dispatcher/index.md) |
| [dns](dns.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;dns&quot;)<br>val [dns](dns.md): [Dns](../-dns/index.md) |
| [eventListenerFactory](event-listener-factory.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;eventListenerFactory&quot;)<br>val [eventListenerFactory](event-listener-factory.md): [EventListener.Factory](../-event-listener/-factory/index.md) |
| [fastFallback](fast-fallback.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;fastFallback&quot;)<br>val [fastFallback](fast-fallback.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [followRedirects](follow-redirects.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;followRedirects&quot;)<br>val [followRedirects](follow-redirects.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [followSslRedirects](follow-ssl-redirects.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;followSslRedirects&quot;)<br>val [followSslRedirects](follow-ssl-redirects.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hostnameVerifier](hostname-verifier.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;hostnameVerifier&quot;)<br>val [hostnameVerifier](hostname-verifier.md): [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html) |
| [interceptors](interceptors.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;interceptors&quot;)<br>val [interceptors](interceptors.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Interceptor](../-interceptor/index.md)&gt;<br>Returns an immutable list of interceptors that observe the full span of each call: from before the connection is established (if any) until after the response source is selected (either the origin server, cache, or both). |
| [minWebSocketMessageToCompress](min-web-socket-message-to-compress.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;minWebSocketMessageToCompress&quot;)<br>val [minWebSocketMessageToCompress](min-web-socket-message-to-compress.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Minimum outbound web socket message size (in bytes) that will be compressed. The default is 1024 bytes. |
| [networkInterceptors](network-interceptors.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;networkInterceptors&quot;)<br>val [networkInterceptors](network-interceptors.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Interceptor](../-interceptor/index.md)&gt;<br>Returns an immutable list of interceptors that observe a single network request and response. These interceptors must call [Interceptor.Chain.proceed](../-interceptor/-chain/proceed.md) exactly once: it is an error for a network interceptor to short-circuit or repeat a network request. |
| [pingIntervalMillis](ping-interval-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;pingIntervalMillis&quot;)<br>val [pingIntervalMillis](ping-interval-millis.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Web socket and HTTP/2 ping interval (in milliseconds). By default pings are not sent. |
| [protocols](protocols.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;protocols&quot;)<br>val [protocols](protocols.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt; |
| [proxy](proxy.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxy&quot;)<br>val [proxy](proxy.md): [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)? |
| [proxyAuthenticator](proxy-authenticator.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxyAuthenticator&quot;)<br>val [proxyAuthenticator](proxy-authenticator.md): [Authenticator](../-authenticator/index.md) |
| [proxySelector](proxy-selector.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;proxySelector&quot;)<br>val [proxySelector](proxy-selector.md): [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html) |
| [readTimeoutMillis](read-timeout-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;readTimeoutMillis&quot;)<br>val [readTimeoutMillis](read-timeout-millis.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Default read timeout (in milliseconds). The default is 10 seconds. |
| [retryOnConnectionFailure](retry-on-connection-failure.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;retryOnConnectionFailure&quot;)<br>val [retryOnConnectionFailure](retry-on-connection-failure.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [socketFactory](socket-factory.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;socketFactory&quot;)<br>val [socketFactory](socket-factory.md): [SocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html) |
| [sslSocketFactory](ssl-socket-factory.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;sslSocketFactory&quot;)<br>val [sslSocketFactory](ssl-socket-factory.md): [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html) |
| [writeTimeoutMillis](write-timeout-millis.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;writeTimeoutMillis&quot;)<br>val [writeTimeoutMillis](write-timeout-millis.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Default write timeout (in milliseconds). The default is 10 seconds. |
| [x509TrustManager](x509-trust-manager.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;x509TrustManager&quot;)<br>val [x509TrustManager](x509-trust-manager.md): [X509TrustManager](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/X509TrustManager.html)? |
