/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RoutePlanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0015J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lokhttp3/internal/connection/FastFallbackExchangeFinder;", "", "routePlanner", "Lokhttp3/internal/connection/RoutePlanner;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(Lokhttp3/internal/connection/RoutePlanner;Lokhttp3/internal/concurrent/TaskRunner;)V", "connectDelayMillis", "", "connectResults", "Ljava/util/concurrent/BlockingQueue;", "Lokhttp3/internal/connection/FastFallbackExchangeFinder$ConnectResult;", "kotlin.jvm.PlatformType", "connectsInFlight", "", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "firstException", "Ljava/io/IOException;", "morePlansExist", "", "awaitConnection", "Lokhttp3/internal/connection/RealConnection;", "find", "launchConnect", "", "trackFailure", "exception", "ConnectResult", "okhttp"})
public final class FastFallbackExchangeFinder {
    @NotNull
    private final RoutePlanner routePlanner;
    @NotNull
    private final TaskRunner taskRunner;
    private final long connectDelayMillis;
    @NotNull
    private List<RoutePlanner.Plan> connectsInFlight;
    @NotNull
    private final BlockingQueue<ConnectResult> connectResults;
    @Nullable
    private IOException firstException;
    private boolean morePlansExist;

    public FastFallbackExchangeFinder(@NotNull RoutePlanner routePlanner, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter((Object)routePlanner, (String)"routePlanner");
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        this.routePlanner = routePlanner;
        this.taskRunner = taskRunner;
        this.connectDelayMillis = 250L;
        this.connectsInFlight = new ArrayList();
        this.connectResults = this.taskRunner.getBackend().decorate(new LinkedBlockingDeque());
        this.morePlansExist = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RealConnection find() {
        try {
            while (this.morePlansExist || !((Collection)this.connectsInFlight).isEmpty()) {
                if (this.routePlanner.isCanceled()) {
                    throw new IOException("Canceled");
                }
                this.launchConnect();
                RealConnection connection = this.awaitConnection();
                if (connection != null) {
                    RealConnection realConnection = connection;
                    return realConnection;
                }
                this.morePlansExist = this.morePlansExist && this.routePlanner.hasMoreRoutes();
            }
            IOException iOException = this.firstException;
            Intrinsics.checkNotNull((Object)iOException);
            throw iOException;
        }
        finally {
            for (RoutePlanner.Plan plan : this.connectsInFlight) {
                plan.cancel();
            }
        }
    }

    private final void launchConnect() {
        RoutePlanner.Plan plan;
        if (!this.morePlansExist) {
            return;
        }
        try {
            plan = this.routePlanner.plan();
        }
        catch (IOException e) {
            this.trackFailure(e);
            return;
        }
        RoutePlanner.Plan plan2 = plan;
        ((Collection)this.connectsInFlight).add(plan2);
        if (plan2.isConnected()) {
            this.connectResults.put(new ConnectResult(plan2, null));
            return;
        }
        String taskName = _UtilJvmKt.okHttpName + " connect " + this.routePlanner.getAddress().url().redact();
        TaskQueue.schedule$default(this.taskRunner.newQueue(), new Task(taskName, plan2, this){
            final /* synthetic */ String $taskName;
            final /* synthetic */ RoutePlanner.Plan $plan;
            final /* synthetic */ FastFallbackExchangeFinder this$0;
            {
                this.$taskName = $taskName;
                this.$plan = $plan;
                this.this$0 = $receiver;
                super($taskName, false, 2, null);
            }

            public long runOnce() {
                try {
                    this.$plan.connect();
                    FastFallbackExchangeFinder.access$getConnectResults$p(this.this$0).put(new ConnectResult(this.$plan, null));
                }
                catch (Throwable e) {
                    FastFallbackExchangeFinder.access$getConnectResults$p(this.this$0).put(new ConnectResult(this.$plan, e));
                }
                return -1L;
            }
        }, 0L, 2, null);
    }

    private final RealConnection awaitConnection() {
        if (this.connectsInFlight.isEmpty()) {
            return null;
        }
        ConnectResult connectResult = this.connectResults.poll(this.connectDelayMillis, TimeUnit.MILLISECONDS);
        if (connectResult == null) {
            return null;
        }
        ConnectResult completed = connectResult;
        this.connectsInFlight.remove(completed.getPlan());
        Throwable exception = completed.getThrowable();
        if (exception instanceof IOException) {
            this.trackFailure((IOException)exception);
            return null;
        }
        if (exception != null) {
            throw exception;
        }
        return completed.getPlan().handleSuccess();
    }

    private final void trackFailure(IOException exception) {
        this.routePlanner.trackFailure(exception);
        if (this.firstException == null) {
            this.firstException = exception;
        } else {
            IOException iOException = this.firstException;
            Intrinsics.checkNotNull((Object)iOException);
            ExceptionsKt.addSuppressed((Throwable)iOException, (Throwable)exception);
        }
    }

    public static final /* synthetic */ BlockingQueue access$getConnectResults$p(FastFallbackExchangeFinder $this) {
        return $this.connectResults;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/connection/FastFallbackExchangeFinder$ConnectResult;", "", "plan", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "throwable", "", "(Lokhttp3/internal/connection/RoutePlanner$Plan;Ljava/lang/Throwable;)V", "getPlan", "()Lokhttp3/internal/connection/RoutePlanner$Plan;", "getThrowable", "()Ljava/lang/Throwable;", "okhttp"})
    private static final class ConnectResult {
        @NotNull
        private final RoutePlanner.Plan plan;
        @Nullable
        private final Throwable throwable;

        public ConnectResult(@NotNull RoutePlanner.Plan plan, @Nullable Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
            this.plan = plan;
            this.throwable = throwable;
        }

        @NotNull
        public final RoutePlanner.Plan getPlan() {
            return this.plan;
        }

        @Nullable
        public final Throwable getThrowable() {
            return this.throwable;
        }
    }
}

