/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.FailedPlan;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RoutePlanner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokhttp3/internal/connection/FastFallbackExchangeFinder;", "Lokhttp3/internal/connection/ExchangeFinder;", "routePlanner", "Lokhttp3/internal/connection/RoutePlanner;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(Lokhttp3/internal/connection/RoutePlanner;Lokhttp3/internal/concurrent/TaskRunner;)V", "connectDelayNanos", "", "connectResults", "Ljava/util/concurrent/BlockingQueue;", "Lokhttp3/internal/connection/RoutePlanner$ConnectResult;", "kotlin.jvm.PlatformType", "deferredPlans", "Lkotlin/collections/ArrayDeque;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "nextTcpConnectAtNanos", "getRoutePlanner", "()Lokhttp3/internal/connection/RoutePlanner;", "tcpConnectsInFlight", "Ljava/util/concurrent/CopyOnWriteArrayList;", "awaitTcpConnect", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "cancelInFlightConnects", "", "find", "Lokhttp3/internal/connection/RealConnection;", "launchTcpConnect", "okhttp"})
public final class FastFallbackExchangeFinder
implements ExchangeFinder {
    @NotNull
    private final RoutePlanner routePlanner;
    @NotNull
    private final TaskRunner taskRunner;
    private final long connectDelayNanos;
    private long nextTcpConnectAtNanos;
    @NotNull
    private final CopyOnWriteArrayList<RoutePlanner.Plan> tcpConnectsInFlight;
    @NotNull
    private final ArrayDeque<RoutePlanner.Plan> deferredPlans;
    @NotNull
    private final BlockingQueue<RoutePlanner.ConnectResult> connectResults;

    public FastFallbackExchangeFinder(@NotNull RoutePlanner routePlanner, @NotNull TaskRunner taskRunner) {
        Intrinsics.checkNotNullParameter((Object)routePlanner, (String)"routePlanner");
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        this.routePlanner = routePlanner;
        this.taskRunner = taskRunner;
        this.connectDelayNanos = TimeUnit.MILLISECONDS.toNanos(250L);
        this.nextTcpConnectAtNanos = Long.MIN_VALUE;
        this.tcpConnectsInFlight = new CopyOnWriteArrayList();
        this.deferredPlans = new ArrayDeque();
        this.connectResults = this.taskRunner.getBackend().decorate(new LinkedBlockingDeque());
    }

    @Override
    @NotNull
    public RoutePlanner getRoutePlanner() {
        return this.routePlanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RealConnection find() {
        IOException firstException = null;
        try {
            while (!((Collection)this.tcpConnectsInFlight).isEmpty() || !((Collection)this.deferredPlans).isEmpty() || RoutePlanner.DefaultImpls.hasNext$default(this.getRoutePlanner(), null, 1, null)) {
                RoutePlanner.Plan nextPlan;
                Throwable throwable;
                if (this.getRoutePlanner().isCanceled()) {
                    throw new IOException("Canceled");
                }
                long now = this.taskRunner.getBackend().nanoTime();
                long awaitTimeoutNanos = this.nextTcpConnectAtNanos - now;
                RoutePlanner.ConnectResult connectResult = null;
                if (this.tcpConnectsInFlight.isEmpty() || awaitTimeoutNanos <= 0L) {
                    connectResult = this.launchTcpConnect();
                    this.nextTcpConnectAtNanos = now + this.connectDelayNanos;
                    awaitTimeoutNanos = this.connectDelayNanos;
                }
                if (connectResult == null) {
                    RoutePlanner.ConnectResult connectResult2 = this.awaitTcpConnect(awaitTimeoutNanos, TimeUnit.NANOSECONDS);
                    if (connectResult2 == null) continue;
                    connectResult = connectResult2;
                }
                if (connectResult.isSuccess()) {
                    this.cancelInFlightConnects();
                    if (!connectResult.getPlan().isReady()) {
                        connectResult = connectResult.getPlan().connectTlsEtc();
                    }
                    if (connectResult.isSuccess()) {
                        RealConnection realConnection = connectResult.getPlan().handleSuccess();
                        return realConnection;
                    }
                }
                if ((throwable = connectResult.getThrowable()) != null) {
                    if (!(throwable instanceof IOException)) {
                        throw throwable;
                    }
                    if (firstException == null) {
                        firstException = (IOException)throwable;
                    } else {
                        ExceptionsKt.addSuppressed((Throwable)firstException, (Throwable)throwable);
                    }
                }
                if ((nextPlan = connectResult.getNextPlan()) == null) continue;
                this.deferredPlans.addFirst((Object)nextPlan);
            }
        }
        finally {
            this.cancelInFlightConnects();
        }
        IOException iOException = firstException;
        Intrinsics.checkNotNull(iOException);
        throw iOException;
    }

    private final RoutePlanner.ConnectResult launchTcpConnect() {
        RoutePlanner.Plan plan;
        if (!((Collection)this.deferredPlans).isEmpty()) {
            plan = (RoutePlanner.Plan)this.deferredPlans.removeFirst();
        } else if (RoutePlanner.DefaultImpls.hasNext$default(this.getRoutePlanner(), null, 1, null)) {
            RoutePlanner.Plan plan2;
            try {
                plan2 = this.getRoutePlanner().plan();
            }
            catch (Throwable e) {
                plan2 = new FailedPlan(e);
            }
            plan = plan2;
        } else {
            return null;
        }
        RoutePlanner.Plan plan3 = plan;
        if (plan3.isReady()) {
            return new RoutePlanner.ConnectResult(plan3, null, null, 6, null);
        }
        if (plan3 instanceof FailedPlan) {
            return ((FailedPlan)plan3).getResult();
        }
        ((Collection)this.tcpConnectsInFlight).add(plan3);
        String taskName = _UtilJvmKt.okHttpName + " connect " + this.getRoutePlanner().getAddress().url().redact();
        TaskQueue.schedule$default(this.taskRunner.newQueue(), new Task(taskName, plan3, this){
            final /* synthetic */ String $taskName;
            final /* synthetic */ RoutePlanner.Plan $plan;
            final /* synthetic */ FastFallbackExchangeFinder this$0;
            {
                this.$taskName = $taskName;
                this.$plan = $plan;
                this.this$0 = $receiver;
                super($taskName, false, 2, null);
            }

            public long runOnce() {
                RoutePlanner.ConnectResult connectResult;
                try {
                    connectResult = this.$plan.connectTcp();
                }
                catch (Throwable e) {
                    connectResult = new RoutePlanner.ConnectResult(this.$plan, null, e, 2, null);
                }
                RoutePlanner.ConnectResult connectResult2 = connectResult;
                if (FastFallbackExchangeFinder.access$getTcpConnectsInFlight$p(this.this$0).contains(this.$plan)) {
                    FastFallbackExchangeFinder.access$getConnectResults$p(this.this$0).put(connectResult2);
                }
                return -1L;
            }
        }, 0L, 2, null);
        return null;
    }

    private final RoutePlanner.ConnectResult awaitTcpConnect(long timeout2, TimeUnit unit) {
        if (this.tcpConnectsInFlight.isEmpty()) {
            return null;
        }
        RoutePlanner.ConnectResult connectResult = this.connectResults.poll(timeout2, unit);
        if (connectResult == null) {
            return null;
        }
        RoutePlanner.ConnectResult result = connectResult;
        this.tcpConnectsInFlight.remove(result.getPlan());
        return result;
    }

    private final void cancelInFlightConnects() {
        for (RoutePlanner.Plan plan : this.tcpConnectsInFlight) {
            RoutePlanner.Plan retry;
            plan.cancel();
            if (plan.retry() == null) continue;
            ((Collection)this.deferredPlans).add(retry);
        }
        this.tcpConnectsInFlight.clear();
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getTcpConnectsInFlight$p(FastFallbackExchangeFinder $this) {
        return $this.tcpConnectsInFlight;
    }

    public static final /* synthetic */ BlockingQueue access$getConnectResults$p(FastFallbackExchangeFinder $this) {
        return $this.connectResults;
    }
}

