/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.Route;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/http/RetryAndFollowUpInterceptor;", "Lokhttp3/Interceptor;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "buildRedirectRequest", "Lokhttp3/Request;", "userResponse", "Lokhttp3/Response;", "method", "", "followUpRequest", "exchange", "Lokhttp3/internal/connection/Exchange;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "isRecoverable", "", "e", "Ljava/io/IOException;", "requestSendStarted", "recover", "call", "Lokhttp3/internal/connection/RealCall;", "userRequest", "requestIsOneShot", "retryAfter", "", "defaultDelay", "Companion", "okhttp"})
public final class RetryAndFollowUpInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    private static final int MAX_FOLLOW_UPS = 20;

    public RetryAndFollowUpInterceptor(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = ((RealInterceptorChain)chain).getRequest$okhttp();
        RealCall call = realChain.getCall$okhttp();
        int followUpCount = 0;
        Response priorResponse = null;
        boolean newRoutePlanner = true;
        List recoveredFailures = CollectionsKt.emptyList();
        while (true) {
            call.enterNetworkInterceptorExchange(request, newRoutePlanner, (RealInterceptorChain)chain);
            Response response = null;
            boolean closeActiveExchange = true;
            if (call.isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                response = realChain.proceed(request);
                newRoutePlanner = true;
            }
            catch (IOException e) {
                if (!this.recover(e, call, request, !(e instanceof ConnectionShutdownException))) {
                    throw _UtilCommonKt.withSuppressed(e, recoveredFailures);
                }
                recoveredFailures = CollectionsKt.plus((Collection)recoveredFailures, (Object)e);
                newRoutePlanner = false;
                call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
            }
            try {
                Exchange exchange;
                Request followUp;
                Response.Builder responseBuilder = response.newBuilder().request(request);
                if (priorResponse != null) {
                    responseBuilder.priorResponse(priorResponse.newBuilder().body(null).build());
                }
                if ((followUp = this.followUpRequest(response = responseBuilder.build(), exchange = call.getInterceptorScopedExchange$okhttp())) == null) {
                    if (exchange != null && exchange.isDuplex$okhttp()) {
                        call.timeoutEarlyExit();
                    }
                    closeActiveExchange = false;
                    Response response2 = response;
                    return response2;
                }
                RequestBody followUpBody = followUp.body();
                if (followUpBody != null && followUpBody.isOneShot()) {
                    closeActiveExchange = false;
                    Response response3 = response;
                    return response3;
                }
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    _UtilCommonKt.closeQuietly(responseBody);
                }
                if (++followUpCount > 20) {
                    throw new ProtocolException(Intrinsics.stringPlus((String)"Too many follow-up requests: ", (Object)followUpCount));
                }
                request = followUp;
                priorResponse = response;
                continue;
            }
            finally {
                call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
                continue;
            }
            break;
        }
    }

    private final boolean recover(IOException e, RealCall call, Request userRequest, boolean requestSendStarted) {
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && this.requestIsOneShot(e, userRequest)) {
            return false;
        }
        if (!this.isRecoverable(e, requestSendStarted)) {
            return false;
        }
        return call.retryAfterFailure();
    }

    private final boolean requestIsOneShot(IOException e, Request userRequest) {
        RequestBody requestBody = userRequest.body();
        return requestBody != null && requestBody.isOneShot() || e instanceof FileNotFoundException;
    }

    private final boolean isRecoverable(IOException e, boolean requestSendStarted) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException && !requestSendStarted;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private final Request followUpRequest(Response userResponse, Exchange exchange) throws IOException {
        Route route;
        Exchange exchange2 = exchange;
        if (exchange2 == null) {
            route = null;
        } else {
            RealConnection realConnection = exchange2.getConnection$okhttp();
            route = realConnection == null ? null : realConnection.route();
        }
        Route route2 = route;
        int responseCode = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode) {
            case 407: {
                Route route3 = route2;
                Intrinsics.checkNotNull((Object)route3);
                Proxy selectedProxy = route3.proxy();
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route2, userResponse);
            }
            case 401: {
                return this.client.authenticator().authenticate(route2, userResponse);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.buildRedirectRequest(userResponse, method);
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 408) {
                    return null;
                }
                if (this.retryAfter(userResponse, 0) > 0) {
                    return null;
                }
                return userResponse.request();
            }
            case 503: {
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 503) {
                    return null;
                }
                if (this.retryAfter(userResponse, Integer.MAX_VALUE) == 0) {
                    return userResponse.request();
                }
                return null;
            }
            case 421: {
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (exchange == null || !exchange.isCoalescedConnection$okhttp()) {
                    return null;
                }
                exchange.getConnection$okhttp().noCoalescedConnections$okhttp();
                return userResponse.request();
            }
        }
        return null;
    }

    private final Request buildRedirectRequest(Response userResponse, String method) {
        if (!this.client.followRedirects()) {
            return null;
        }
        String string = Response.header$default(userResponse, "Location", null, 2, null);
        if (string == null) {
            return null;
        }
        String location = string;
        HttpUrl httpUrl = userResponse.request().url().resolve(location);
        if (httpUrl == null) {
            return null;
        }
        HttpUrl url = httpUrl;
        boolean sameScheme = Intrinsics.areEqual((Object)url.scheme(), (Object)userResponse.request().url().scheme());
        if (!sameScheme && !this.client.followSslRedirects()) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        if (HttpMethod.permitsRequestBody(method)) {
            boolean maintainBody;
            int responseCode = userResponse.code();
            boolean bl = maintainBody = HttpMethod.INSTANCE.redirectsWithBody(method) || responseCode == 308 || responseCode == 307;
            if (HttpMethod.INSTANCE.redirectsToGet(method) && responseCode != 308 && responseCode != 307) {
                requestBuilder.method("GET", null);
            } else {
                RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                requestBuilder.method(method, requestBody);
            }
            if (!maintainBody) {
                requestBuilder.removeHeader("Transfer-Encoding");
                requestBuilder.removeHeader("Content-Length");
                requestBuilder.removeHeader("Content-Type");
            }
        }
        if (!_UtilJvmKt.canReuseConnectionFor(userResponse.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.url(url).build();
    }

    private final int retryAfter(Response userResponse, int defaultDelay) {
        String string = Response.header$default(userResponse, "Retry-After", null, 2, null);
        if (string == null) {
            return defaultDelay;
        }
        String header = string;
        Object object = header;
        if (new Regex("\\d+").matches((CharSequence)object)) {
            object = Integer.valueOf(header);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueOf(header)");
            return ((Number)object).intValue();
        }
        return Integer.MAX_VALUE;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http/RetryAndFollowUpInterceptor$Companion;", "", "()V", "MAX_FOLLOW_UPS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

