/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.connection.ConnectPlan;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.ReusePlan;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020#H\u0002J'\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00152\u0010\b\u0002\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010&H\u0000\u00a2\u0006\u0002\b'J\n\u0010(\u001a\u0004\u0018\u00010)H\u0002J-\u0010*\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010#2\u0010\b\u0002\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010&H\u0000\u00a2\u0006\u0002\b,J\u0012\u0010-\u001a\u0004\u0018\u00010\u00152\u0006\u0010.\u001a\u00020\u001fH\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u000201H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lokhttp3/internal/connection/RealRoutePlanner;", "Lokhttp3/internal/connection/RoutePlanner;", "client", "Lokhttp3/OkHttpClient;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "(Lokhttp3/OkHttpClient;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/internal/http/RealInterceptorChain;)V", "getAddress", "()Lokhttp3/Address;", "deferredPlans", "Lkotlin/collections/ArrayDeque;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "getDeferredPlans", "()Lkotlin/collections/ArrayDeque;", "doExtensiveHealthChecks", "", "nextRouteToTry", "Lokhttp3/Route;", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "createTunnelRequest", "Lokhttp3/Request;", "route", "hasNext", "failedConnection", "Lokhttp3/internal/connection/RealConnection;", "isCanceled", "plan", "planConnect", "Lokhttp3/internal/connection/ConnectPlan;", "planConnectToRoute", "routes", "", "planConnectToRoute$okhttp", "planReuseCallConnection", "Lokhttp3/internal/connection/ReusePlan;", "planReusePooledConnection", "planToReplace", "planReusePooledConnection$okhttp", "retryRoute", "connection", "sameHostAndPort", "url", "Lokhttp3/HttpUrl;", "okhttp"})
public final class RealRoutePlanner
implements RoutePlanner {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Address address;
    @NotNull
    private final RealCall call;
    private final boolean doExtensiveHealthChecks;
    @Nullable
    private RouteSelector.Selection routeSelection;
    @Nullable
    private RouteSelector routeSelector;
    @Nullable
    private Route nextRouteToTry;
    @NotNull
    private final ArrayDeque<RoutePlanner.Plan> deferredPlans;

    public RealRoutePlanner(@NotNull OkHttpClient client, @NotNull Address address, @NotNull RealCall call, @NotNull RealInterceptorChain chain) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        this.client = client;
        this.address = address;
        this.call = call;
        this.doExtensiveHealthChecks = !Intrinsics.areEqual((Object)chain.getRequest$okhttp().method(), (Object)"GET");
        this.deferredPlans = new ArrayDeque();
    }

    @Override
    @NotNull
    public Address getAddress() {
        return this.address;
    }

    @Override
    @NotNull
    public ArrayDeque<RoutePlanner.Plan> getDeferredPlans() {
        return this.deferredPlans;
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @NotNull
    public RoutePlanner.Plan plan() throws IOException {
        ReusePlan pooled2;
        ReusePlan pooled1;
        ReusePlan reuseCallConnection;
        ReusePlan reusePlan = reuseCallConnection = this.planReuseCallConnection();
        if (reusePlan != null) {
            return reusePlan;
        }
        ReusePlan reusePlan2 = pooled1 = RealRoutePlanner.planReusePooledConnection$okhttp$default(this, null, null, 3, null);
        if (reusePlan2 != null) {
            return reusePlan2;
        }
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return (RoutePlanner.Plan)this.getDeferredPlans().removeFirst();
        }
        ConnectPlan connect2 = this.planConnect();
        ReusePlan reusePlan3 = pooled2 = this.planReusePooledConnection$okhttp(connect2, connect2.getRoutes$okhttp());
        if (reusePlan3 != null) {
            return reusePlan3;
        }
        return connect2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ReusePlan planReuseCallConnection() {
        Object object;
        RealConnection realConnection = this.call.getConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection candidate = realConnection;
        boolean healthy = candidate.isHealthy(this.doExtensiveHealthChecks);
        RealConnection realConnection2 = candidate;
        synchronized (realConnection2) {
            Socket socket;
            boolean bl = false;
            if (!healthy) {
                candidate.setNoNewExchanges(true);
                socket = this.call.releaseConnectionNoEvents$okhttp();
            } else {
                socket = candidate.getNoNewExchanges() || !this.sameHostAndPort(candidate.route().address().url()) ? this.call.releaseConnectionNoEvents$okhttp() : null;
            }
            object = socket;
        }
        Socket toClose = object;
        if (this.call.getConnection() != null) {
            if (!(toClose == null)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            return new ReusePlan(candidate);
        }
        Socket socket = toClose;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        this.call.getEventListener$okhttp().connectionReleased(this.call, candidate);
        return null;
    }

    private final ConnectPlan planConnect() throws IOException {
        RouteSelector.Selection newRouteSelection;
        Route localNextRouteToTry = this.nextRouteToTry;
        if (localNextRouteToTry != null) {
            this.nextRouteToTry = null;
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, localNextRouteToTry, null, 2, null);
        }
        RouteSelector.Selection existingRouteSelection = this.routeSelection;
        if (existingRouteSelection != null && existingRouteSelection.hasNext()) {
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, existingRouteSelection.next(), null, 2, null);
        }
        RouteSelector newRouteSelector = this.routeSelector;
        if (newRouteSelector == null) {
            this.routeSelector = newRouteSelector = new RouteSelector(this.getAddress(), this.call.getClient().getRouteDatabase$okhttp(), this.call, this.client.fastFallback(), this.call.getEventListener$okhttp());
        }
        if (!newRouteSelector.hasNext()) {
            throw new IOException("exhausted all routes");
        }
        this.routeSelection = newRouteSelection = newRouteSelector.next();
        if (this.call.isCanceled()) {
            throw new IOException("Canceled");
        }
        return this.planConnectToRoute$okhttp(newRouteSelection.next(), newRouteSelection.getRoutes());
    }

    @Nullable
    public final ReusePlan planReusePooledConnection$okhttp(@Nullable ConnectPlan planToReplace, @Nullable List<Route> routes) {
        RealConnection realConnection = this.client.connectionPool().getDelegate$okhttp().callAcquirePooledConnection(this.doExtensiveHealthChecks, this.getAddress(), this.call, routes, planToReplace != null && planToReplace.isReady());
        if (realConnection == null) {
            return null;
        }
        RealConnection result = realConnection;
        if (planToReplace != null) {
            this.nextRouteToTry = planToReplace.getRoute();
            planToReplace.closeQuietly();
        }
        this.call.getEventListener$okhttp().connectionAcquired(this.call, result);
        return new ReusePlan(result);
    }

    public static /* synthetic */ ReusePlan planReusePooledConnection$okhttp$default(RealRoutePlanner realRoutePlanner, ConnectPlan connectPlan, List list, int n, Object object) {
        if ((n & 1) != 0) {
            connectPlan = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planReusePooledConnection$okhttp(connectPlan, list);
    }

    @NotNull
    public final ConnectPlan planConnectToRoute$okhttp(@NotNull Route route, @Nullable List<Route> routes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        if (route.address().sslSocketFactory() == null) {
            if (!route.address().connectionSpecs().contains(ConnectionSpec.CLEARTEXT)) {
                throw new UnknownServiceException("CLEARTEXT communication not enabled for client");
            }
            String host = route.address().url().host();
            if (!Platform.Companion.get().isCleartextTrafficPermitted(host)) {
                throw new UnknownServiceException("CLEARTEXT communication to " + host + " not permitted by network security policy");
            }
        } else if (route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS");
        }
        Request tunnelRequest = route.requiresTunnel() ? this.createTunnelRequest(route) : null;
        return new ConnectPlan(this.client, this.call, this, route, routes, 0, tunnelRequest, -1, false);
    }

    public static /* synthetic */ ConnectPlan planConnectToRoute$okhttp$default(RealRoutePlanner realRoutePlanner, Route route, List list, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planConnectToRoute$okhttp(route, list);
    }

    private final Request createTunnelRequest(Route route) throws IOException {
        Request proxyConnectRequest = new Request.Builder().url(route.address().url()).method("CONNECT", null).header("Host", _UtilJvmKt.toHostHeader(route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/5.0.0-alpha.7").build();
        Response fakeAuthChallengeResponse = new Response.Builder().request(proxyConnectRequest).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request authenticatedRequest = route.address().proxyAuthenticator().authenticate(route, fakeAuthChallengeResponse);
        Request request = authenticatedRequest;
        if (request == null) {
            request = proxyConnectRequest;
        }
        return request;
    }

    @Override
    public boolean hasNext(@Nullable RealConnection failedConnection) {
        Route retryRoute;
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return true;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        if (failedConnection != null && (retryRoute = this.retryRoute(failedConnection)) != null) {
            this.nextRouteToTry = retryRoute;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        boolean bl = selection != null ? selection.hasNext() : false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector = this.routeSelector;
        if (routeSelector == null) {
            return true;
        }
        RouteSelector localRouteSelector = routeSelector;
        return localRouteSelector.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Route retryRoute(RealConnection connection) {
        RealConnection realConnection = connection;
        synchronized (realConnection) {
            block8: {
                block7: {
                    block6: {
                        boolean bl = false;
                        if (connection.getRouteFailureCount$okhttp() == 0) break block6;
                        Route route = null;
                        return route;
                    }
                    if (connection.getNoNewExchanges()) break block7;
                    Route route = null;
                    return route;
                }
                if (_UtilJvmKt.canReuseConnectionFor(connection.route().address().url(), this.getAddress().url())) break block8;
                Route route = null;
                return route;
            }
            Route route = connection.route();
            return route;
        }
    }

    @Override
    public boolean sameHostAndPort(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl routeUrl = this.getAddress().url();
        return url.port() == routeUrl.port() && Intrinsics.areEqual((Object)url.host(), (Object)routeUrl.host());
    }
}

