/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal._UtilCommonKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\"\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\n\u0010\u000e\u001a\u00020\u0003*\u00020\u0005\u001a\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0005H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0003*\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"VERIFY_AS_IP_ADDRESS", "Lkotlin/text/Regex;", "decodeIpv4Suffix", "", "input", "", "pos", "", "limit", "address", "", "addressOffset", "decodeIpv6", "inet6AddressToAscii", "canParseAsIpAddress", "containsInvalidHostnameAsciiCodes", "containsInvalidLabelLengths", "okhttp"})
public final class _HostnamesCommonKt {
    @NotNull
    private static final Regex VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    public static final boolean canParseAsIpAddress(@NotNull String $this$canParseAsIpAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$canParseAsIpAddress, (String)"<this>");
        return VERIFY_AS_IP_ADDRESS.matches((CharSequence)$this$canParseAsIpAddress);
    }

    public static final boolean containsInvalidLabelLengths(@NotNull String $this$containsInvalidLabelLengths) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInvalidLabelLengths, (String)"<this>");
        int n = $this$containsInvalidLabelLengths.length();
        if (!(1 <= n ? n < 254 : false)) {
            return true;
        }
        int labelStart = 0;
        while (true) {
            int dot;
            int labelLength;
            int n2 = labelLength = (dot = StringsKt.indexOf$default((CharSequence)$this$containsInvalidLabelLengths, (char)'.', (int)labelStart, (boolean)false, (int)4, null)) == -1 ? $this$containsInvalidLabelLengths.length() - labelStart : dot - labelStart;
            if (!(1 <= labelLength ? labelLength < 64 : false)) {
                return true;
            }
            if (dot == -1 || dot == $this$containsInvalidLabelLengths.length() - 1) break;
            labelStart = dot + 1;
        }
        return false;
    }

    public static final boolean containsInvalidHostnameAsciiCodes(@NotNull String $this$containsInvalidHostnameAsciiCodes) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInvalidHostnameAsciiCodes, (String)"<this>");
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i = 0; i < n; ++i) {
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i);
            if (Intrinsics.compare((int)c, (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)c, (int)0, (boolean)false, (int)6, null) == -1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final byte[] decodeIpv6(@NotNull String input, int pos, int limit) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i = pos;
        while (i < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default((String)input, (String)":", (int)i, (boolean)false, (int)4, null)) {
                if (StringsKt.startsWith$default((String)input, (String)".", (int)i, (boolean)false, (int)4, null)) {
                    if (!_HostnamesCommonKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i;
            while (i < limit && (hexDigit = _UtilCommonKt.parseHexDigit(input.charAt(i))) != -1) {
                value = (value << 4) + hexDigit;
                ++i;
            }
            int groupLength = i - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8 & 0xFF);
            address[b++] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            ArraysKt.copyInto((byte[])address, (byte[])address, (int)(address.length - (b - compress)), (int)compress, (int)b);
            ArraysKt.fill((byte[])address, (byte)0, (int)compress, (int)(compress + (address.length - b)));
        }
        return address;
    }

    public static final boolean decodeIpv4Suffix(@NotNull String input, int pos, int limit, @NotNull byte[] address, int addressOffset) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int b = addressOffset;
        int i = pos;
        while (i < limit) {
            int c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt(i) != '.') {
                return false;
            }
            int value = 0;
            int groupOffset = ++i;
            while (i < limit && Intrinsics.compare((int)(c = input.charAt(i)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                int $this$code$iv = c;
                boolean $i$f$getCode = false;
                int n = value * 10 + $this$code$iv;
                $this$code$iv = 48;
                $i$f$getCode = false;
                value = n - $this$code$iv;
                if (value > 255) {
                    return false;
                }
                ++i;
            }
            int groupLength = i - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    @NotNull
    public static final String inet6AddressToAscii(@NotNull byte[] address) {
        int i;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int longestRunOffset = 0;
        longestRunOffset = -1;
        int longestRunLength = 0;
        boolean bl = false;
        for (i = 0; i < address.length; i += 2) {
            int currentRunOffset = i;
            while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                i += 2;
            }
            int currentRunLength = i - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result = new Buffer();
        i = 0;
        while (i < address.length) {
            boolean $i$f$getCode;
            int $this$code$iv;
            if (i == longestRunOffset) {
                $this$code$iv = 58;
                $i$f$getCode = false;
                result.writeByte($this$code$iv);
                if ((i += longestRunLength) != 16) continue;
                $this$code$iv = 58;
                $i$f$getCode = false;
                result.writeByte($this$code$iv);
                continue;
            }
            if (i > 0) {
                $this$code$iv = 58;
                $i$f$getCode = false;
                result.writeByte($this$code$iv);
            }
            int group = _UtilCommonKt.and(address[i], 255) << 8 | _UtilCommonKt.and(address[i + 1], 255);
            result.writeHexadecimalUnsignedLong((long)group);
            i += 2;
        }
        return result.readUtf8();
    }
}

