/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.sse;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.sse.ServerSentEventReader;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u0004\u001a\u00020\u0005H\u0016J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lokhttp3/internal/sse/RealEventSource;", "Lokhttp3/sse/EventSource;", "Lokhttp3/internal/sse/ServerSentEventReader$Callback;", "Lokhttp3/Callback;", "request", "Lokhttp3/Request;", "listener", "Lokhttp3/sse/EventSourceListener;", "(Lokhttp3/Request;Lokhttp3/sse/EventSourceListener;)V", "call", "Lokhttp3/Call;", "cancel", "", "connect", "client", "Lokhttp3/OkHttpClient;", "onEvent", "id", "", "type", "data", "onFailure", "e", "Ljava/io/IOException;", "onResponse", "response", "Lokhttp3/Response;", "onRetryChange", "timeMs", "", "processResponse", "isEventStream", "", "Lokhttp3/ResponseBody;", "okhttp-sse"})
public final class RealEventSource
implements EventSource,
ServerSentEventReader.Callback,
Callback {
    private Call call;
    private final Request request;
    private final EventSourceListener listener;

    public final void connect(@NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        OkHttpClient client2 = client.newBuilder().eventListener(EventListener.NONE).build();
        Call call = this.call = client2.newCall(this.request);
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        }
        call.enqueue((Callback)this);
    }

    public void onResponse(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.processResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processResponse(@NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Closeable closeable = (Closeable)response;
        boolean bl = false;
        Throwable throwable = null;
        try {
            ResponseBody body;
            Response it = (Response)closeable;
            boolean bl2 = false;
            if (!response.isSuccessful()) {
                this.listener.onFailure(this, null, response);
                return;
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                Intrinsics.throwNpe();
            }
            if (!this.isEventStream(body = responseBody)) {
                this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + body.contentType()), response);
                return;
            }
            Exchange exchange = Internal.instance.exchange(response);
            if (exchange != null) {
                exchange.timeoutEarlyExit();
            }
            Response response2 = response.newBuilder().body(Util.EMPTY_RESPONSE).build();
            ServerSentEventReader reader = new ServerSentEventReader(body.source(), this);
            try {
                this.listener.onOpen(this, response2);
                while (reader.processNextEvent()) {
                }
            }
            catch (Exception e) {
                this.listener.onFailure(this, e, response2);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return;
            }
            this.listener.onClosed(this);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final boolean isEventStream(@NotNull ResponseBody $this$isEventStream) {
        MediaType mediaType = $this$isEventStream.contentType();
        if (mediaType == null) {
            return false;
        }
        MediaType contentType = mediaType;
        return Intrinsics.areEqual((Object)contentType.type(), (Object)"text") && Intrinsics.areEqual((Object)contentType.subtype(), (Object)"event-stream");
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.listener.onFailure(this, e, null);
    }

    @Override
    @NotNull
    public Request request() {
        return this.request;
    }

    @Override
    public void cancel() {
        Call call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        }
        call.cancel();
    }

    @Override
    public void onEvent(@Nullable String id, @Nullable String type, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.listener.onEvent(this, id, type, data);
    }

    @Override
    public void onRetryChange(long timeMs) {
    }

    public RealEventSource(@NotNull Request request, @NotNull EventSourceListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.request = request;
        this.listener = listener;
    }
}

