/*
 * Copyright (C) 2018 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package okhttp3.sse

import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.Response
import okhttp3.internal.sse.RealEventSource

object EventSources {
  @JvmStatic
  fun createFactory(client: OkHttpClient): EventSource.Factory {
    return object : EventSource.Factory {
      override fun newEventSource(request: Request, listener: EventSourceListener): EventSource {
        val actualRequest =
          if (request.header("Accept") == null) {
            request.newBuilder().addHeader("Accept", "text/event-stream").build()
          } else {
            request
          }

        return RealEventSource(actualRequest, listener).apply {
          connect(client)
        }
      }
    }
  }

  @JvmStatic
  fun processResponse(response: Response, listener: EventSourceListener) {
    val eventSource = RealEventSource(response.request, listener)
    eventSource.processResponse(response)
  }
}
