//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Response](index.md)/[request](request.md)

# request

[common, nonJvm]\
[common]\
expect val [request](request.md): [Request](../-request/index.md)

[nonJvm]\
actual val [request](request.md): [Request](../-request/index.md)

The request that initiated this HTTP response. This is not necessarily the same request issued by the application:

- 
   It may be transformed by the user's interceptors. For example, an application interceptor may add headers like User-Agent.
- 
   It may be the request generated in response to an HTTP redirect or authentication challenge. In this case the request URL may be different than the initial request URL.

Use the request of the [networkResponse](network-response.md) field to get the wire-level request that was transmitted. In the case of follow-ups and redirects, also look at the request of the [priorResponse](prior-response.md) objects, which have its own [priorResponse](prior-response.md).

[jvm]\

@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;request&quot;)

actual val [request](request.md): [Request](../-request/index.md)
