//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Call](index.md)

# Call

[jvm]\
interface [Call](index.md) : [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html)

A call is a request that has been prepared for execution. A call can be canceled. As this object represents a single request/response pair (stream), it cannot be executed twice.

## Types

| Name | Summary |
|---|---|
| [Factory](-factory/index.md) | [jvm]<br>fun interface [Factory](-factory/index.md) |

## Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | [jvm]<br>abstract fun [cancel](cancel.md)()<br>Cancels the request, if possible. Requests that are already complete cannot be canceled. |
| [clone](clone.md) | [jvm]<br>abstract override fun [clone](clone.md)(): [Call](index.md)<br>Create a new, identical call to this one which can be enqueued or executed even if this call has already been. |
| [enqueue](enqueue.md) | [jvm]<br>abstract fun [enqueue](enqueue.md)(responseCallback: [Callback](../-callback/index.md))<br>Schedules the request to be executed at some point in the future. |
| [execute](execute.md) | [jvm]<br>abstract fun [execute](execute.md)(): [Response](../-response/index.md)<br>Invokes the request immediately, and blocks until the response can be processed or is in error. |
| [isCanceled](is-canceled.md) | [jvm]<br>abstract fun [isCanceled](is-canceled.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isExecuted](is-executed.md) | [jvm]<br>abstract fun [isExecuted](is-executed.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this call has been either [executed](execute.md) or [enqueued](enqueue.md). It is an error to execute a call more than once. |
| [request](request.md) | [jvm]<br>abstract fun [request](request.md)(): [Request](../-request/index.md)<br>Returns the original request that initiated this call. |
| [timeout](timeout.md) | [jvm]<br>abstract fun [timeout](timeout.md)(): [Timeout](https://square.github.io/okio/2.x/okio/okio/-timeout/index.html)<br>Returns a timeout that spans the entire call: resolving DNS, connecting, writing the request body, server processing, and reading the response body. If the call requires redirects or retries all must complete within one timeout period. |
