//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[topPrivateDomain](top-private-domain.md)

# topPrivateDomain

[jvm]\
fun [topPrivateDomain](top-private-domain.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?

Returns the domain name of this URL's [host](host.md) that is one level beneath the public suffix by consulting the [public suffix list](https://publicsuffix.org). Returns null if this URL's [host](host.md) is an IP address or is considered a public suffix by the public suffix list.

In general this method **should not** be used to test whether a domain is valid or routable. Instead, DNS is the recommended source for that information.

| URL | topPrivateDomain() |
|---|---|
| http://google.com | "google.com" |
| http://adwords.google.co.uk | "google.co.uk" |
| http://square | null |
| http://co.uk | null |
| http://localhost | null |
| http://127.0.0.1 | null |
