//[mockwebserver](../../../index.md)/[okhttp3.mockwebserver](../index.md)/[MockResponse](index.md)

# MockResponse

[jvm]\
class [MockResponse](index.md) : [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [addHeader](add-header.md) | [jvm]<br>fun [addHeader](add-header.md)(header: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md)<br>fun [addHeader](add-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [MockResponse](index.md) |
| [addHeaderLenient](add-header-lenient.md) | [jvm]<br>fun [addHeaderLenient](add-header-lenient.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [MockResponse](index.md) |
| [clearHeaders](clear-headers.md) | [jvm]<br>fun [clearHeaders](clear-headers.md)(): [MockResponse](index.md) |
| [clone](clone.md) | [jvm]<br>open override fun [clone](clone.md)(): [MockResponse](index.md) |
| [getBody](get-body.md) | [jvm]<br>fun [getBody](get-body.md)(): [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html)? |
| [getBodyDelay](get-body-delay.md) | [jvm]<br>fun [getBodyDelay](get-body-delay.md)(unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [getHeadersDelay](get-headers-delay.md) | [jvm]<br>fun [getHeadersDelay](get-headers-delay.md)(unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [getThrottlePeriod](get-throttle-period.md) | [jvm]<br>fun [getThrottlePeriod](get-throttle-period.md)(unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [removeHeader](remove-header.md) | [jvm]<br>fun [removeHeader](remove-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md) |
| [setBody](set-body.md) | [jvm]<br>fun [setBody](set-body.md)(body: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md)<br>fun [setBody](set-body.md)(body: [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html)): [MockResponse](index.md) |
| [setBodyDelay](set-body-delay.md) | [jvm]<br>fun [setBodyDelay](set-body-delay.md)(delay: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [MockResponse](index.md) |
| [setChunkedBody](set-chunked-body.md) | [jvm]<br>fun [setChunkedBody](set-chunked-body.md)(body: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), maxChunkSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md)<br>fun [setChunkedBody](set-chunked-body.md)(body: [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html), maxChunkSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md) |
| [setHeader](set-header.md) | [jvm]<br>fun [setHeader](set-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [MockResponse](index.md) |
| [setHeaders](set-headers.md) | [jvm]<br>fun [setHeaders](set-headers.md)(headers: Headers): [MockResponse](index.md) |
| [setHeadersDelay](set-headers-delay.md) | [jvm]<br>fun [setHeadersDelay](set-headers-delay.md)(delay: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [MockResponse](index.md) |
| [setHttp2ErrorCode](set-http2-error-code.md) | [jvm]<br>fun [setHttp2ErrorCode](set-http2-error-code.md)(http2ErrorCode: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md) |
| [setResponseCode](set-response-code.md) | [jvm]<br>fun [setResponseCode](set-response-code.md)(code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md) |
| [setSocketPolicy](set-socket-policy.md) | [jvm]<br>fun [setSocketPolicy](set-socket-policy.md)(socketPolicy: [SocketPolicy](../-socket-policy/index.md)): [MockResponse](index.md) |
| [setStatus](set-status.md) | [jvm]<br>fun [setStatus](set-status.md)(status: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md) |
| [setTrailers](set-trailers.md) | [jvm]<br>fun [setTrailers](set-trailers.md)(trailers: Headers): [MockResponse](index.md) |
| [throttleBody](throttle-body.md) | [jvm]<br>fun [throttleBody](throttle-body.md)(bytesPerPeriod: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), period: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [MockResponse](index.md) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [withPush](with-push.md) | [jvm]<br>fun [withPush](with-push.md)(promise: [PushPromise](../-push-promise/index.md)): [MockResponse](index.md) |
| [withSettings](with-settings.md) | [jvm]<br>fun [withSettings](with-settings.md)(settings: Settings): [MockResponse](index.md) |
| [withWebSocketUpgrade](with-web-socket-upgrade.md) | [jvm]<br>fun [withWebSocketUpgrade](with-web-socket-upgrade.md)(listener: WebSocketListener): [MockResponse](index.md) |

## Properties

| Name | Summary |
|---|---|
| [headers](headers.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "headers")<br>var [headers](headers.md): Headers |
| [http2ErrorCode](http2-error-code.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "http2ErrorCode")<br>var [http2ErrorCode](http2-error-code.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [pushPromises](push-promises.md) | [jvm]<br>val [pushPromises](push-promises.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[PushPromise](../-push-promise/index.md)&gt; |
| [settings](settings.md) | [jvm]<br>var [settings](settings.md): Settings |
| [socketPolicy](socket-policy.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "socketPolicy")<br>var [socketPolicy](socket-policy.md): [SocketPolicy](../-socket-policy/index.md) |
| [status](status.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "status")<br>var [status](status.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [throttleBytesPerPeriod](throttle-bytes-per-period.md) | [jvm]<br>var [throttleBytesPerPeriod](throttle-bytes-per-period.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [trailers](trailers.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "trailers")<br>var [trailers](trailers.md): Headers |
| [webSocketListener](web-socket-listener.md) | [jvm]<br>var [webSocketListener](web-socket-listener.md): WebSocketListener? = null |
