//[okhttp](../../../index.md)/[okhttp3](../index.md)/[MultipartBody](index.md)

# MultipartBody

[jvm]\
class [MultipartBody](index.md) : [RequestBody](../-request-body/index.md)

An [RFC 2387](http://www.ietf.org/rfc/rfc2387.txt)-compliant request body.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(boundary: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |
| [Part](-part/index.md) | [jvm]<br>class [Part](-part/index.md) |

## Functions

| Name | Summary |
|---|---|
| [contentLength](content-length.md) | [jvm]<br>open override fun [contentLength](content-length.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [contentType](content-type.md) | [jvm]<br>open override fun [contentType](content-type.md)(): [MediaType](../-media-type/index.md)<br>A combination of [type](type.md) and boundaryByteString. |
| [isDuplex](../-request-body/is-duplex.md) | [jvm]<br>actual open fun [isDuplex](../-request-body/is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isOneShot](../-request-body/is-one-shot.md) | [jvm]<br>actual open fun [isOneShot](../-request-body/is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [part](part.md) | [jvm]<br>fun [part](part.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MultipartBody.Part](-part/index.md) |
| [writeTo](write-to.md) | [jvm]<br>open override fun [writeTo](write-to.md)(sink: [BufferedSink](https://square.github.io/okio/2.x/okio/okio/-buffered-sink/index.html)) |

## Properties

| Name | Summary |
|---|---|
| [boundary](boundary.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "boundary")<br>val [boundary](boundary.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [parts](parts.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "parts")<br>val [parts](parts.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[MultipartBody.Part](-part/index.md)&gt; |
| [size](size.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "size")<br>val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The number of parts in this multipart body. |
| [type](type.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "type")<br>val [type](type.md): [MediaType](../-media-type/index.md) |
