//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[MockResponse](index.md)

# MockResponse

[jvm]\
class [MockResponse](index.md) : [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html)

A scripted response to be replayed by the mock web server.

## Constructors

| | |
|---|---|
| [MockResponse](-mock-response.md) | [jvm]<br>fun [MockResponse](-mock-response.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [add100Continue](add100-continue.md) | [jvm]<br>fun [add100Continue](add100-continue.md)(): [MockResponse](index.md) |
| [addHeader](add-header.md) | [jvm]<br>fun [addHeader](add-header.md)(header: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md)<br>Adds [header](add-header.md) as an HTTP header. For well-formed HTTP [header](add-header.md) should contain a name followed by a colon and a value.<br>[jvm]<br>fun [addHeader](add-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [MockResponse](index.md)<br>Adds a new header with the name and value. This may be used to add multiple headers with the same name. |
| [addHeaderLenient](add-header-lenient.md) | [jvm]<br>fun [addHeaderLenient](add-header-lenient.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [MockResponse](index.md)<br>Adds a new header with the name and value. This may be used to add multiple headers with the same name. Unlike [addHeader](add-header.md) this does not validate the name and value. |
| [addInformationalResponse](add-informational-response.md) | [jvm]<br>fun [addInformationalResponse](add-informational-response.md)(response: [MockResponse](index.md)): [MockResponse](index.md)<br>Adds an HTTP 1xx response to precede this response. Note that this response's [headers delay](set-headers-delay.md) applies after this response is transmitted. Set a headers delay on that response to delay its transmission. |
| [clearHeaders](clear-headers.md) | [jvm]<br>fun [clearHeaders](clear-headers.md)(): [MockResponse](index.md)<br>Removes all HTTP headers including any &quot;Content-Length&quot; and &quot;Transfer-encoding&quot; headers that were added by default. |
| [clone](clone.md) | [jvm]<br>open override fun [clone](clone.md)(): [MockResponse](index.md) |
| [getBody](get-body.md) | [jvm]<br>fun [getBody](get-body.md)(): [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html)?<br>Returns a copy of the raw HTTP payload. |
| [getBodyDelay](get-body-delay.md) | [jvm]<br>fun [getBodyDelay](get-body-delay.md)(unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [getHeadersDelay](get-headers-delay.md) | [jvm]<br>fun [getHeadersDelay](get-headers-delay.md)(unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [getThrottlePeriod](get-throttle-period.md) | [jvm]<br>fun [getThrottlePeriod](get-throttle-period.md)(unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [removeHeader](remove-header.md) | [jvm]<br>fun [removeHeader](remove-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md)<br>Removes all headers named [name](remove-header.md). |
| [setBody](set-body.md) | [jvm]<br>fun [setBody](set-body.md)(body: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md)<br>Sets the response body to the UTF-8 encoded bytes of [body](set-body.md).<br>[jvm]<br>fun [setBody](set-body.md)(duplexResponseBody: DuplexResponseBody): [MockResponse](index.md)<br>fun [setBody](set-body.md)(body: [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html)): [MockResponse](index.md) |
| [setBodyDelay](set-body-delay.md) | [jvm]<br>fun [setBodyDelay](set-body-delay.md)(delay: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [MockResponse](index.md)<br>Set the delayed time of the response body to [delay](set-body-delay.md). This applies to the response body only; response headers are not affected. |
| [setChunkedBody](set-chunked-body.md) | [jvm]<br>fun [setChunkedBody](set-chunked-body.md)(body: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), maxChunkSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md)<br>Sets the response body to the UTF-8 encoded bytes of [body](set-chunked-body.md), chunked every [maxChunkSize](set-chunked-body.md) bytes.<br>[jvm]<br>fun [setChunkedBody](set-chunked-body.md)(body: [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html), maxChunkSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md)<br>Sets the response body to [body](set-chunked-body.md), chunked every [maxChunkSize](set-chunked-body.md) bytes. |
| [setHeader](set-header.md) | [jvm]<br>fun [setHeader](set-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [MockResponse](index.md)<br>Removes all headers named [name](set-header.md), then adds a new header with the name and value. |
| [setHeaders](set-headers.md) | [jvm]<br>fun [setHeaders](set-headers.md)(headers: Headers): [MockResponse](index.md)<br>Sets the headers and returns this. |
| [setHeadersDelay](set-headers-delay.md) | [jvm]<br>fun [setHeadersDelay](set-headers-delay.md)(delay: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [MockResponse](index.md) |
| [setHttp2ErrorCode](set-http2-error-code.md) | [jvm]<br>fun [setHttp2ErrorCode](set-http2-error-code.md)(http2ErrorCode: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md)<br>Sets the HTTP/2 error code and returns this. |
| [setResponseCode](set-response-code.md) | [jvm]<br>fun [setResponseCode](set-response-code.md)(code: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [MockResponse](index.md) |
| [setSocketPolicy](set-socket-policy.md) | [jvm]<br>fun [setSocketPolicy](set-socket-policy.md)(socketPolicy: [SocketPolicy](../-socket-policy/index.md)): [MockResponse](index.md)<br>Sets the socket policy and returns this. |
| [setStatus](set-status.md) | [jvm]<br>fun [setStatus](set-status.md)(status: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MockResponse](index.md)<br>Sets the status and returns this. |
| [setTrailers](set-trailers.md) | [jvm]<br>fun [setTrailers](set-trailers.md)(trailers: Headers): [MockResponse](index.md)<br>Sets the trailers and returns this. |
| [throttleBody](throttle-body.md) | [jvm]<br>fun [throttleBody](throttle-body.md)(bytesPerPeriod: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), period: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [MockResponse](index.md)<br>Throttles the request reader and response writer to sleep for the given period after each series of [bytesPerPeriod](throttle-body.md) bytes are transferred. Use this to simulate network behavior. |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [withPush](with-push.md) | [jvm]<br>fun [withPush](with-push.md)(promise: [PushPromise](../-push-promise/index.md)): [MockResponse](index.md)<br>When [protocols](../-mock-web-server/protocols.md) include HTTP_2, this attaches a pushed stream to this response. |
| [withSettings](with-settings.md) | [jvm]<br>fun [withSettings](with-settings.md)(settings: Settings): [MockResponse](index.md)<br>When [protocols](../-mock-web-server/protocols.md) include HTTP_2, this pushes [settings](with-settings.md) before writing the response. |
| [withWebSocketUpgrade](with-web-socket-upgrade.md) | [jvm]<br>fun [withWebSocketUpgrade](with-web-socket-upgrade.md)(listener: WebSocketListener): [MockResponse](index.md)<br>Attempts to perform a web socket upgrade on the connection. This will overwrite any previously set status or body. |

## Properties

| Name | Summary |
|---|---|
| [code](code.md) | [jvm]<br>val [code](code.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [duplexResponseBody](duplex-response-body.md) | [jvm]<br>val [duplexResponseBody](duplex-response-body.md): DuplexResponseBody? = null |
| [headers](headers.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;headers&quot;)<br>var [headers](headers.md): Headers<br>The HTTP headers, such as &quot;Content-Length: 0&quot;. |
| [http2ErrorCode](http2-error-code.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;http2ErrorCode&quot;)<br>var [http2ErrorCode](http2-error-code.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Sets the [HTTP/2 error code](https://tools.ietf.org/html/rfc7540#section-7) to be returned when resetting the stream. This is only valid with [SocketPolicy.RESET_STREAM_AT_START](../-socket-policy/-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md) and [SocketPolicy.DO_NOT_READ_REQUEST_BODY](../-socket-policy/-d-o_-n-o-t_-r-e-a-d_-r-e-q-u-e-s-t_-b-o-d-y/index.md). |
| [informationalResponses](informational-responses.md) | [jvm]<br>val [informationalResponses](informational-responses.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[MockResponse](index.md)&gt; |
| [isDuplex](is-duplex.md) | [jvm]<br>val [isDuplex](is-duplex.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [message](message.md) | [jvm]<br>val [message](message.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [pushPromises](push-promises.md) | [jvm]<br>val [pushPromises](push-promises.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[PushPromise](../-push-promise/index.md)&gt;<br>Returns the streams the server will push with this response. |
| [settings](settings.md) | [jvm]<br>val [settings](settings.md): Settings |
| [socketPolicy](socket-policy.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;socketPolicy&quot;)<br>var [socketPolicy](socket-policy.md): [SocketPolicy](../-socket-policy/index.md) |
| [status](status.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;status&quot;)<br>var [status](status.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the HTTP response line, such as &quot;HTTP/1.1 200 OK&quot;. |
| [throttleBytesPerPeriod](throttle-bytes-per-period.md) | [jvm]<br>val [throttleBytesPerPeriod](throttle-bytes-per-period.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [trailers](trailers.md) | [jvm]<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;trailers&quot;)<br>var [trailers](trailers.md): Headers |
| [webSocketListener](web-socket-listener.md) | [jvm]<br>val [webSocketListener](web-socket-listener.md): WebSocketListener? = null |
