//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[Request](../index.md)/[Builder](index.md)

# Builder

[common]\
expect open class [Builder](index.md)

[jvm, nonJvm]\
actual open class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [common]<br>expect fun [Builder](-builder.md)()<br>[jvm, nonJvm]<br>actual fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [addHeader](add-header.md) | [common]<br>expect open fun [addHeader](add-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Adds a header with [name](add-header.md) and [value](add-header.md). Prefer this method for multiply-valued headers like &quot;Cookie&quot;.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [addHeader](add-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md) |
| [build](build.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [build](build.md)(): [Request](../index.md)<br>[jvm, nonJvm]<br>actual open fun [build](build.md)(): [Request](../index.md) |
| [cacheControl](cache-control.md) | [common]<br>expect open fun [cacheControl](cache-control.md)(cacheControl: [CacheControl](../../-cache-control/index.md)): [Request.Builder](index.md)<br>Sets this request's Cache-Control header, replacing any cache control headers already present. If [cacheControl](cache-control.md) doesn't define any directives, this clears this request's cache-control headers.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [cacheControl](cache-control.md)(cacheControl: [CacheControl](../../-cache-control/index.md)): [Request.Builder](index.md) |
| [delete](delete.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [delete](delete.md)(body: [RequestBody](../../-request-body/index.md)? = commonEmptyRequestBody): [Request.Builder](index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>actual open fun [delete](delete.md)(body: [RequestBody](../../-request-body/index.md)? = commonEmptyRequestBody): [Request.Builder](index.md)<br>[nonJvm]<br>actual open fun [delete](delete.md)(body: [RequestBody](../../-request-body/index.md)? = commonEmptyRequestBody): [Request.Builder](index.md) |
| [get](get.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [get](get.md)(): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual open fun [get](get.md)(): [Request.Builder](index.md) |
| [head](head.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [head](head.md)(): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual open fun [head](head.md)(): [Request.Builder](index.md) |
| [header](header.md) | [common]<br>expect open fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Sets the header named [name](header.md) to [value](header.md). If this request already has any headers with that name, they are all replaced.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md) |
| [headers](headers.md) | [common]<br>expect open fun [headers](headers.md)(headers: [Headers](../../-headers/index.md)): [Request.Builder](index.md)<br>Removes all headers on this builder and adds [headers](headers.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [headers](headers.md)(headers: [Headers](../../-headers/index.md)): [Request.Builder](index.md) |
| [method](method.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [method](method.md)(method: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), body: [RequestBody](../../-request-body/index.md)?): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual open fun [method](method.md)(method: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), body: [RequestBody](../../-request-body/index.md)?): [Request.Builder](index.md) |
| [patch](patch.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [patch](patch.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual open fun [patch](patch.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md) |
| [post](post.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [post](post.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual open fun [post](post.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md) |
| [put](put.md) | [common, jvm, nonJvm]<br>[common]<br>expect open fun [put](put.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual open fun [put](put.md)(body: [RequestBody](../../-request-body/index.md)): [Request.Builder](index.md) |
| [removeHeader](remove-header.md) | [common]<br>expect open fun [removeHeader](remove-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Removes all headers named [name](remove-header.md) on this builder.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [removeHeader](remove-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md) |
| [tag](tag.md) | [common]<br>expect inline fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(tag: [T](tag.md)?): [Request.Builder](index.md)<br>Attaches [tag](tag.md) to the request using [T](tag.md) as a key. Tags can be read from a request using [Request.tag](../tag.md). Use null to remove any existing tag assigned for [T](tag.md).<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;reifiedTag&quot;)<br>actual inline fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(tag: [T](tag.md)?): [Request.Builder](index.md)<br>[nonJvm]<br>actual inline fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(tag: [T](tag.md)?): [Request.Builder](index.md)<br>[jvm, nonJvm]<br>actual fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](tag.md)&gt;, tag: [T](tag.md)?): [Request.Builder](index.md)<br>[jvm]<br>open fun [tag](tag.md)(tag: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Request.Builder](index.md)<br>Attaches [tag](tag.md) to the request using Object.class as a key.<br>[jvm, common]<br>[jvm]<br>open fun &lt;[T](tag.md)&gt; [tag](tag.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;in [T](tag.md)&gt;, tag: [T](tag.md)?): [Request.Builder](index.md)<br>[common]<br>expect fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](tag.md)&gt;, tag: [T](tag.md)?): [Request.Builder](index.md)<br>Attaches [tag](tag.md) to the request using [type](tag.md) as a key. Tags can be read from a request using [Request.tag](../tag.md). Use null to remove any existing tag assigned for [type](tag.md). |
| [url](url.md) | [jvm, common]<br>[jvm]<br>open fun [url](url.md)(url: [URL](https://docs.oracle.com/javase/8/docs/api/java/net/URL.html)): [Request.Builder](index.md)<br>[common]<br>expect open fun [url](url.md)(url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>Sets the URL target of this request.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [url](url.md)(url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Request.Builder](index.md)<br>[jvm]<br>open fun [url](url.md)(url: [HttpUrl](../../-http-url/index.md)): [Request.Builder](index.md) |
