/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import okhttp3.internal.http2.Header;

public final class TestUtil {
    public static final InetSocketAddress UNREACHABLE_ADDRESS = new InetSocketAddress("198.51.100.1", 8080);
    private static final Dns SINGLE_INET_ADDRESS_DNS = new Dns(){

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            List addresses = Dns.SYSTEM.lookup(hostname);
            return Collections.singletonList(addresses.get(0));
        }
    };
    private static final ConnectionPool connectionPool = new ConnectionPool();
    private static final Dispatcher dispatcher = new Dispatcher();

    private TestUtil() {
    }

    public static OkHttpClient defaultClient() {
        return new OkHttpClient.Builder().connectionPool(connectionPool).dispatcher(dispatcher).dns(SINGLE_INET_ADDRESS_DNS).build();
    }

    public static List<Header> headerEntries(String ... elements) {
        ArrayList<Header> result = new ArrayList<Header>(elements.length / 2);
        for (int i = 0; i < elements.length; i += 2) {
            result.add(new Header(elements[i], elements[i + 1]));
        }
        return result;
    }

    public static String repeat(char c, int count) {
        char[] array = new char[count];
        Arrays.fill(array, c);
        return new String(array);
    }

    public static void awaitGarbageCollection() throws Exception {
        Runtime.getRuntime().gc();
        Thread.sleep(100L);
        System.runFinalization();
    }
}

