/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.Dns;
import org.junit.Assert;

public final class FakeDns
implements Dns {
    private List<String> requestedHosts = new ArrayList<String>();
    private List<InetAddress> addresses = Collections.emptyList();

    public FakeDns addresses(List<InetAddress> addresses) {
        this.addresses = new ArrayList<InetAddress>(addresses);
        return this;
    }

    public FakeDns unknownHost() {
        this.addresses = Collections.emptyList();
        return this;
    }

    public InetAddress address(int index) {
        return this.addresses.get(index);
    }

    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        this.requestedHosts.add(hostname);
        if (this.addresses.isEmpty()) {
            throw new UnknownHostException();
        }
        return this.addresses;
    }

    public void assertRequests(String ... expectedHosts) {
        Assert.assertEquals(Arrays.asList(expectedHosts), this.requestedHosts);
        this.requestedHosts.clear();
    }
}

