/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.TlsUtil;

public final class HandshakeCertificates {
    private final X509KeyManager keyManager;
    private final X509TrustManager trustManager;

    private HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    public X509KeyManager keyManager() {
        return this.keyManager;
    }

    public X509TrustManager trustManager() {
        return this.trustManager;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslContext().getSocketFactory();
    }

    public SSLContext sslContext() {
        try {
            SSLContext sslContext = Platform.get().getSSLContext();
            sslContext.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class Builder {
        private HeldCertificate heldCertificate;
        private X509Certificate[] intermediates;
        private final List<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();

        public Builder heldCertificate(HeldCertificate heldCertificate, X509Certificate ... intermediates) {
            this.heldCertificate = heldCertificate;
            this.intermediates = (X509Certificate[])intermediates.clone();
            return this;
        }

        public Builder addTrustedCertificate(X509Certificate certificate) {
            this.trustedCertificates.add(certificate);
            return this;
        }

        public Builder addPlatformTrustedCertificates() {
            X509TrustManager platformTrustManager = Util.platformTrustManager();
            Collections.addAll(this.trustedCertificates, platformTrustManager.getAcceptedIssuers());
            return this;
        }

        public HandshakeCertificates build() {
            try {
                X509KeyManager keyManager = TlsUtil.newKeyManager(null, this.heldCertificate, this.intermediates);
                X509TrustManager trustManager = TlsUtil.newTrustManager(null, this.trustedCertificates);
                return new HandshakeCertificates(keyManager, trustManager);
            }
            catch (GeneralSecurityException gse) {
                throw new AssertionError((Object)gse);
            }
        }
    }
}

