/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.TlsUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/tls/HandshakeCertificates;", "", "keyManager", "Ljavax/net/ssl/X509KeyManager;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "(Ljavax/net/ssl/X509KeyManager;Ljavax/net/ssl/X509TrustManager;)V", "sslContext", "Ljavax/net/ssl/SSLContext;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Builder", "okhttp-tls"})
public final class HandshakeCertificates {
    private final X509KeyManager keyManager;
    private final X509TrustManager trustManager;

    @NotNull
    public final X509KeyManager keyManager() {
        return this.keyManager;
    }

    @NotNull
    public final X509TrustManager trustManager() {
        return this.trustManager;
    }

    @NotNull
    public final SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.sslContext().getSocketFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLSocketFactory, (String)"sslContext().socketFactory");
        return sSLSocketFactory;
    }

    @NotNull
    public final SSLContext sslContext() {
        SSLContext sSLContext = Platform.Companion.get().newSSLContext();
        boolean bl = false;
        boolean bl2 = false;
        SSLContext $this$apply = sSLContext;
        boolean bl3 = false;
        $this$apply.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, new SecureRandom());
        return sSLContext;
    }

    private HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    public /* synthetic */ HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager, DefaultConstructorMarker $constructor_marker) {
        this(keyManager, trustManager);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ'\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/tls/HandshakeCertificates$Builder;", "", "()V", "heldCertificate", "Lokhttp3/tls/HeldCertificate;", "intermediates", "", "Ljava/security/cert/X509Certificate;", "[Ljava/security/cert/X509Certificate;", "trustedCertificates", "", "addPlatformTrustedCertificates", "addTrustedCertificate", "certificate", "build", "Lokhttp3/tls/HandshakeCertificates;", "(Lokhttp3/tls/HeldCertificate;[Ljava/security/cert/X509Certificate;)Lokhttp3/tls/HandshakeCertificates$Builder;", "okhttp-tls"})
    public static final class Builder {
        private HeldCertificate heldCertificate;
        private X509Certificate[] intermediates;
        private final List<X509Certificate> trustedCertificates;

        @NotNull
        public final Builder heldCertificate(@NotNull HeldCertificate heldCertificate, X509Certificate ... intermediates) {
            Intrinsics.checkParameterIsNotNull((Object)heldCertificate, (String)"heldCertificate");
            Intrinsics.checkParameterIsNotNull((Object)intermediates, (String)"intermediates");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.heldCertificate = heldCertificate;
            $this$apply.intermediates = Arrays.copyOf(intermediates, intermediates.length);
            return builder;
        }

        @NotNull
        public final Builder addTrustedCertificate(@NotNull X509Certificate certificate) {
            Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = $this$apply.trustedCertificates;
            X509Certificate x509Certificate = certificate;
            boolean bl4 = false;
            collection.add(x509Certificate);
            return builder;
        }

        @NotNull
        public final Builder addPlatformTrustedCertificates() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            X509TrustManager platformTrustManager = Platform.Companion.get().platformTrustManager();
            X509Certificate[] x509CertificateArray = platformTrustManager.getAcceptedIssuers();
            Collections.addAll((Collection)$this$apply.trustedCertificates, Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
            return builder;
        }

        @NotNull
        public final HandshakeCertificates build() {
            String string = null;
            HeldCertificate heldCertificate = this.heldCertificate;
            X509Certificate[] x509CertificateArray = this.intermediates;
            if (this.intermediates == null) {
                HeldCertificate heldCertificate2 = heldCertificate;
                String string2 = string;
                boolean $i$f$emptyArray = false;
                X509Certificate[] x509CertificateArray2 = new X509Certificate[]{};
                string = string2;
                heldCertificate = heldCertificate2;
                x509CertificateArray = x509CertificateArray2;
            }
            X509KeyManager keyManager = TlsUtil.newKeyManager(string, heldCertificate, Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
            X509TrustManager trustManager = TlsUtil.newTrustManager(null, this.trustedCertificates);
            return new HandshakeCertificates(keyManager, trustManager, null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.trustedCertificates = list = (List)new ArrayList();
        }
    }
}

