/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okhttp3.internal.Util;
import okio.ByteString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokhttp3/tls/HeldCertificate;", "", "keyPair", "Ljava/security/KeyPair;", "certificate", "Ljava/security/cert/X509Certificate;", "(Ljava/security/KeyPair;Ljava/security/cert/X509Certificate;)V", "certificatePem", "", "pkcs1Bytes", "Lokio/ByteString;", "privateKeyPkcs1Pem", "privateKeyPkcs8Pem", "encodeBase64Lines", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "data", "Builder", "okhttp-tls"})
public final class HeldCertificate {
    private final KeyPair keyPair;
    private final X509Certificate certificate;

    @NotNull
    public final X509Certificate certificate() {
        return this.certificate;
    }

    @NotNull
    public final KeyPair keyPair() {
        return this.keyPair;
    }

    @NotNull
    public final String certificatePem() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("-----BEGIN CERTIFICATE-----\n");
        byte[] byArray = this.certificate.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificate.encoded");
        this.encodeBase64Lines($this$buildString, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$buildString.append("-----END CERTIFICATE-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String privateKeyPkcs8Pem() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("-----BEGIN PRIVATE KEY-----\n");
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyPair.private");
        byte[] byArray = privateKey.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"keyPair.private.encoded");
        this.encodeBase64Lines($this$buildString, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$buildString.append("-----END PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String privateKeyPkcs1Pem() {
        boolean bl = this.keyPair.getPrivate() instanceof RSAPrivateKey;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "PKCS1 only supports RSA keys";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        bl3 = false;
        boolean bl5 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl6 = false;
        $this$buildString.append("-----BEGIN RSA PRIVATE KEY-----\n");
        this.encodeBase64Lines($this$buildString, this.pkcs1Bytes());
        $this$buildString.append("-----END RSA PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final ByteString pkcs1Bytes() {
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyPair.private");
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        ASN1Primitive aSN1Primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Primitive, (String)"privateKeyInfo.parsePrivateKey().toASN1Primitive()");
        byte[] byArray = aSN1Primitive.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"privateKeyInfo.parsePriv\u2026toASN1Primitive().encoded");
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void encodeBase64Lines(@NotNull StringBuilder $this$encodeBase64Lines, ByteString data) {
        String base64 = data.base64();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)base64.length())), (int)64);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                void var7_7 = i + 64;
                int n6 = base64.length();
                void var12_12 = i;
                CharSequence charSequence = base64;
                StringBuilder stringBuilder = $this$encodeBase64Lines;
                boolean bl = false;
                int n7 = Math.min((int)var7_7, n6);
                stringBuilder.append(charSequence, (int)var12_12, n7).append('\n');
                if (i == n2) break;
                i += n3;
            }
        }
    }

    public HeldCertificate(@NotNull KeyPair keyPair, @NotNull X509Certificate certificate) {
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        this.keyPair = keyPair;
        this.certificate = certificate;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0000J\b\u0010 \u001a\u00020\tH\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/tls/HeldCertificate$Builder;", "", "()V", "altNames", "", "", "cn", "keyAlgorithm", "keyPair", "Ljava/security/KeyPair;", "keySize", "", "maxIntermediateCas", "notAfter", "", "notBefore", "ou", "serialNumber", "Ljava/math/BigInteger;", "signedBy", "Lokhttp3/tls/HeldCertificate;", "addSubjectAlternativeName", "altName", "build", "buildSubject", "Ljavax/security/auth/x500/X500Principal;", "certificateAuthority", "commonName", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "ecdsa256", "generateKeyPair", "publicKey", "Ljava/security/PublicKey;", "privateKey", "Ljava/security/PrivateKey;", "organizationalUnit", "rsa2048", "validityInterval", "Companion", "okhttp-tls"})
    public static final class Builder {
        private long notBefore = -1L;
        private long notAfter = -1L;
        private String cn;
        private String ou;
        private final List<String> altNames;
        private BigInteger serialNumber;
        private KeyPair keyPair;
        private HeldCertificate signedBy;
        private int maxIntermediateCas;
        private String keyAlgorithm;
        private int keySize;
        private static final long DEFAULT_DURATION_MILLIS = 86400000L;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Builder validityInterval(long notBefore, long notAfter) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = notBefore <= notAfter && notBefore == -1L == (notAfter == -1L);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "invalid interval: " + notBefore + ".." + notAfter;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.notBefore = notBefore;
            $this$apply.notAfter = notAfter;
            return builder;
        }

        @NotNull
        public final Builder duration(long duration, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            long now = System.currentTimeMillis();
            $this$apply.validityInterval(now, now + unit.toMillis(duration));
            return builder;
        }

        @NotNull
        public final Builder addSubjectAlternativeName(@NotNull String altName) {
            Intrinsics.checkParameterIsNotNull((Object)altName, (String)"altName");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = $this$apply.altNames;
            String string = altName;
            boolean bl4 = false;
            collection.add(string);
            return builder;
        }

        @NotNull
        public final Builder commonName(@NotNull String cn) {
            Intrinsics.checkParameterIsNotNull((Object)cn, (String)"cn");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cn = cn;
            return builder;
        }

        @NotNull
        public final Builder organizationalUnit(@NotNull String ou) {
            Intrinsics.checkParameterIsNotNull((Object)ou, (String)"ou");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.ou = ou;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(@NotNull BigInteger serialNumber) {
            Intrinsics.checkParameterIsNotNull((Object)serialNumber, (String)"serialNumber");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.serialNumber = serialNumber;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(long serialNumber) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            BigInteger bigInteger = BigInteger.valueOf(serialNumber);
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(serialNumber)");
            $this$apply.serialNumber(bigInteger);
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull KeyPair keyPair) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyPair = keyPair;
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull PublicKey publicKey, @NotNull PrivateKey privateKey) {
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyPair(new KeyPair(publicKey, privateKey));
            return builder;
        }

        @NotNull
        public final Builder signedBy(@Nullable HeldCertificate signedBy) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.signedBy = signedBy;
            return builder;
        }

        @NotNull
        public final Builder certificateAuthority(int maxIntermediateCas) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = maxIntermediateCas >= 0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "maxIntermediateCas < 0: " + maxIntermediateCas;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.maxIntermediateCas = maxIntermediateCas;
            return builder;
        }

        @NotNull
        public final Builder ecdsa256() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyAlgorithm = "EC";
            $this$apply.keySize = 256;
            return builder;
        }

        @NotNull
        public final Builder rsa2048() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyAlgorithm = "RSA";
            $this$apply.keySize = 2048;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HeldCertificate build() {
            X509Certificate certificate;
            KeyPair keyPair = this.keyPair;
            if (keyPair == null) {
                keyPair = this.generateKeyPair();
            }
            KeyPair heldKeyPair = keyPair;
            X500Principal subject = this.buildSubject();
            KeyPair signedByKeyPair = null;
            X500Principal signedByPrincipal = null;
            if (this.signedBy != null) {
                HeldCertificate heldCertificate = this.signedBy;
                if (heldCertificate == null) {
                    Intrinsics.throwNpe();
                }
                signedByKeyPair = heldCertificate.keyPair;
                HeldCertificate heldCertificate2 = this.signedBy;
                if (heldCertificate2 == null) {
                    Intrinsics.throwNpe();
                }
                X500Principal x500Principal = heldCertificate2.certificate.getSubjectX500Principal();
                Intrinsics.checkExpressionValueIsNotNull((Object)x500Principal, (String)"signedBy!!.certificate.subjectX500Principal");
                signedByPrincipal = x500Principal;
            } else {
                signedByKeyPair = heldKeyPair;
                signedByPrincipal = subject;
            }
            long notBefore = this.notBefore != -1L ? this.notBefore : System.currentTimeMillis();
            long notAfter = this.notAfter != -1L ? this.notAfter : notBefore + 86400000L;
            BigInteger serialNumber = this.serialNumber != null ? this.serialNumber : BigInteger.ONE;
            String signatureAlgorithm = signedByKeyPair.getPrivate() instanceof RSAPrivateKey ? "SHA256WithRSAEncryption" : "SHA256withECDSA";
            X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
            generator.setSerialNumber(serialNumber);
            generator.setIssuerDN(signedByPrincipal);
            generator.setNotBefore(new Date(notBefore));
            generator.setNotAfter(new Date(notAfter));
            generator.setSubjectDN(subject);
            generator.setPublicKey(heldKeyPair.getPublic());
            generator.setSignatureAlgorithm(signatureAlgorithm);
            if (this.maxIntermediateCas != -1) {
                generator.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(this.maxIntermediateCas));
            }
            Collection collection = this.altNames;
            int n = 0;
            if (!collection.isEmpty()) {
                ASN1Encodable[] encodableAltNames = new ASN1Encodable[this.altNames.size()];
                n = 0;
                int n2 = this.altNames.size();
                while (n < n2) {
                    void i;
                    String altName = this.altNames.get((int)i);
                    int tag = Util.canParseAsIpAddress((String)altName) ? 7 : 2;
                    encodableAltNames[i] = (ASN1Encodable)new GeneralName(tag, altName);
                    ++i;
                }
                generator.addExtension(X509Extensions.SubjectAlternativeName, true, (ASN1Encodable)new DERSequence(encodableAltNames));
            }
            X509Certificate x509Certificate = certificate = generator.generate(signedByKeyPair.getPrivate());
            Intrinsics.checkExpressionValueIsNotNull((Object)x509Certificate, (String)"certificate");
            return new HeldCertificate(heldKeyPair, x509Certificate);
        }

        private final X500Principal buildSubject() {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl4 = false;
            $this$buildString.append("CN=");
            if (this.cn != null) {
                $this$buildString.append(this.cn);
            } else {
                $this$buildString.append(UUID.randomUUID());
            }
            if (this.ou != null) {
                $this$buildString.append(", OU=");
                $this$buildString.append(this.ou);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String name = string;
            return new X500Principal(name);
        }

        private final KeyPair generateKeyPair() {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgorithm);
            keyPairGenerator.initialize(this.keySize, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"keyPairGenerator.generateKeyPair()");
            return keyPair;
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.altNames = list = (List)new ArrayList();
            this.maxIntermediateCas = -1;
            this.ecdsa256();
        }

        static {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/tls/HeldCertificate$Builder$Companion;", "", "()V", "DEFAULT_DURATION_MILLIS", "", "okhttp-tls"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

