/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J/\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ/\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\u00152\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0014\u001a\u00020\u00152\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lokhttp3/tls/internal/InsecureExtendedTrustManager;", "Ljavax/net/ssl/X509ExtendedTrustManager;", "delegate", "insecureHosts", "", "", "(Ljavax/net/ssl/X509ExtendedTrustManager;Ljava/util/List;)V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "socket", "Ljava/net/Socket;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/net/Socket;)Ljava/lang/Void;", "engine", "Ljavax/net/ssl/SSLEngine;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljavax/net/ssl/SSLEngine;)Ljava/lang/Void;", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)Ljava/lang/Void;", "checkServerTrusted", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljava/net/Socket;)V", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;Ljavax/net/ssl/SSLEngine;)V", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "okhttp-tls"})
@IgnoreJRERequirement
public final class InsecureExtendedTrustManager
extends X509ExtendedTrustManager {
    @NotNull
    private final X509ExtendedTrustManager delegate;
    @NotNull
    private final List<String> insecureHosts;

    public InsecureExtendedTrustManager(@NotNull X509ExtendedTrustManager delegate, @NotNull List<String> insecureHosts) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        this.delegate = delegate;
        this.insecureHosts = insecureHosts;
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = this.delegate.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray, (String)"delegate.acceptedIssuers");
        return x509CertificateArray;
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @NotNull Socket socket) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (!this.insecureHosts.contains(Util.peerName((Socket)socket))) {
            this.delegate.checkServerTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @NotNull SSLEngine engine) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        if (!this.insecureHosts.contains(engine.getPeerHost())) {
            this.delegate.checkServerTrusted(chain, authType, engine);
        }
    }

    @NotNull
    public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @Nullable SSLEngine engine) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @Nullable Socket socket) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }
}

