/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.ByteString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\u000bJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0018\u0010\u0011\u001a\u00020\u0012*\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\u0018"}, d2={"Lokhttp3/tls/HeldCertificate;", "", "keyPair", "Ljava/security/KeyPair;", "certificate", "Ljava/security/cert/X509Certificate;", "(Ljava/security/KeyPair;Ljava/security/cert/X509Certificate;)V", "()Ljava/security/cert/X509Certificate;", "()Ljava/security/KeyPair;", "-deprecated_certificate", "certificatePem", "", "-deprecated_keyPair", "pkcs1Bytes", "Lokio/ByteString;", "privateKeyPkcs1Pem", "privateKeyPkcs8Pem", "encodeBase64Lines", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "data", "Builder", "Companion", "okhttp-tls"})
public final class HeldCertificate {
    @NotNull
    private final KeyPair keyPair;
    @NotNull
    private final X509Certificate certificate;
    private static final Regex PEM_REGEX;
    public static final Companion Companion;

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="certificate"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_certificate")
    @NotNull
    public final X509Certificate -deprecated_certificate() {
        return this.certificate;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="keyPair"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_keyPair")
    @NotNull
    public final KeyPair -deprecated_keyPair() {
        return this.keyPair;
    }

    @NotNull
    public final String certificatePem() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("-----BEGIN CERTIFICATE-----\n");
        byte[] byArray = this.certificate.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificate.encoded");
        this.encodeBase64Lines($this$buildString, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$buildString.append("-----END CERTIFICATE-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String privateKeyPkcs8Pem() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("-----BEGIN PRIVATE KEY-----\n");
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyPair.private");
        byte[] byArray = privateKey.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"keyPair.private.encoded");
        this.encodeBase64Lines($this$buildString, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$buildString.append("-----END PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String privateKeyPkcs1Pem() {
        boolean bl = this.keyPair.getPrivate() instanceof RSAPrivateKey;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "PKCS1 only supports RSA keys";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        bl3 = false;
        boolean bl5 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl6 = false;
        $this$buildString.append("-----BEGIN RSA PRIVATE KEY-----\n");
        this.encodeBase64Lines($this$buildString, this.pkcs1Bytes());
        $this$buildString.append("-----END RSA PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final ByteString pkcs1Bytes() {
        PrivateKey privateKey = this.keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyPair.private");
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        ASN1Primitive aSN1Primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Primitive, (String)"privateKeyInfo.parsePrivateKey().toASN1Primitive()");
        byte[] byArray = aSN1Primitive.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"privateKeyInfo.parsePriv\u2026toASN1Primitive().encoded");
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void encodeBase64Lines(@NotNull StringBuilder $this$encodeBase64Lines, ByteString data) {
        String base64 = data.base64();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)base64.length())), (int)64);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                void var7_7 = i + 64;
                int n6 = base64.length();
                void var12_12 = i;
                CharSequence charSequence = base64;
                StringBuilder stringBuilder = $this$encodeBase64Lines;
                boolean bl = false;
                int n7 = Math.min((int)var7_7, n6);
                stringBuilder.append(charSequence, (int)var12_12, n7).append('\n');
                if (i == n2) break;
                i += n3;
            }
        }
    }

    @JvmName(name="keyPair")
    @NotNull
    public final KeyPair keyPair() {
        return this.keyPair;
    }

    @JvmName(name="certificate")
    @NotNull
    public final X509Certificate certificate() {
        return this.certificate;
    }

    public HeldCertificate(@NotNull KeyPair keyPair, @NotNull X509Certificate certificate) {
        Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
        Intrinsics.checkParameterIsNotNull((Object)certificate, (String)"certificate");
        this.keyPair = keyPair;
        this.certificate = certificate;
    }

    static {
        Companion = new Companion(null);
        PEM_REGEX = new Regex("-----BEGIN ([!-,.-~ ]*)-----([^-]*)-----END \\1-----");
    }

    @JvmStatic
    @NotNull
    public static final HeldCertificate decode(@NotNull String certificateAndPrivateKeyPem) {
        return Companion.decode(certificateAndPrivateKeyPem);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0000J\b\u0010 \u001a\u00020\tH\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/tls/HeldCertificate$Builder;", "", "()V", "altNames", "", "", "cn", "keyAlgorithm", "keyPair", "Ljava/security/KeyPair;", "keySize", "", "maxIntermediateCas", "notAfter", "", "notBefore", "ou", "serialNumber", "Ljava/math/BigInteger;", "signedBy", "Lokhttp3/tls/HeldCertificate;", "addSubjectAlternativeName", "altName", "build", "buildSubject", "Ljavax/security/auth/x500/X500Principal;", "certificateAuthority", "commonName", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "ecdsa256", "generateKeyPair", "publicKey", "Ljava/security/PublicKey;", "privateKey", "Ljava/security/PrivateKey;", "organizationalUnit", "rsa2048", "validityInterval", "Companion", "okhttp-tls"})
    public static final class Builder {
        private long notBefore = -1L;
        private long notAfter = -1L;
        private String cn;
        private String ou;
        private final List<String> altNames;
        private BigInteger serialNumber;
        private KeyPair keyPair;
        private HeldCertificate signedBy;
        private int maxIntermediateCas;
        private String keyAlgorithm;
        private int keySize;
        private static final long DEFAULT_DURATION_MILLIS = 86400000L;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Builder validityInterval(long notBefore, long notAfter) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = notBefore <= notAfter && notBefore == -1L == (notAfter == -1L);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "invalid interval: " + notBefore + ".." + notAfter;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.notBefore = notBefore;
            $this$apply.notAfter = notAfter;
            return builder;
        }

        @NotNull
        public final Builder duration(long duration, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            long now = System.currentTimeMillis();
            $this$apply.validityInterval(now, now + unit.toMillis(duration));
            return builder;
        }

        @NotNull
        public final Builder addSubjectAlternativeName(@NotNull String altName) {
            Intrinsics.checkParameterIsNotNull((Object)altName, (String)"altName");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = $this$apply.altNames;
            String string = altName;
            boolean bl4 = false;
            collection.add(string);
            return builder;
        }

        @NotNull
        public final Builder commonName(@NotNull String cn) {
            Intrinsics.checkParameterIsNotNull((Object)cn, (String)"cn");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.cn = cn;
            return builder;
        }

        @NotNull
        public final Builder organizationalUnit(@NotNull String ou) {
            Intrinsics.checkParameterIsNotNull((Object)ou, (String)"ou");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.ou = ou;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(@NotNull BigInteger serialNumber) {
            Intrinsics.checkParameterIsNotNull((Object)serialNumber, (String)"serialNumber");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.serialNumber = serialNumber;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(long serialNumber) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            BigInteger bigInteger = BigInteger.valueOf(serialNumber);
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"BigInteger.valueOf(serialNumber)");
            $this$apply.serialNumber(bigInteger);
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull KeyPair keyPair) {
            Intrinsics.checkParameterIsNotNull((Object)keyPair, (String)"keyPair");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyPair = keyPair;
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull PublicKey publicKey, @NotNull PrivateKey privateKey) {
            Intrinsics.checkParameterIsNotNull((Object)publicKey, (String)"publicKey");
            Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyPair(new KeyPair(publicKey, privateKey));
            return builder;
        }

        @NotNull
        public final Builder signedBy(@Nullable HeldCertificate signedBy) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.signedBy = signedBy;
            return builder;
        }

        @NotNull
        public final Builder certificateAuthority(int maxIntermediateCas) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            boolean bl4 = maxIntermediateCas >= 0;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "maxIntermediateCas < 0: " + maxIntermediateCas;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.maxIntermediateCas = maxIntermediateCas;
            return builder;
        }

        @NotNull
        public final Builder ecdsa256() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyAlgorithm = "EC";
            $this$apply.keySize = 256;
            return builder;
        }

        @NotNull
        public final Builder rsa2048() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.keyAlgorithm = "RSA";
            $this$apply.keySize = 2048;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HeldCertificate build() {
            X509Certificate certificate;
            KeyPair keyPair = this.keyPair;
            if (keyPair == null) {
                keyPair = this.generateKeyPair();
            }
            KeyPair heldKeyPair = keyPair;
            X500Principal subject = this.buildSubject();
            KeyPair signedByKeyPair = null;
            X500Principal signedByPrincipal = null;
            if (this.signedBy != null) {
                HeldCertificate heldCertificate = this.signedBy;
                if (heldCertificate == null) {
                    Intrinsics.throwNpe();
                }
                signedByKeyPair = heldCertificate.keyPair();
                HeldCertificate heldCertificate2 = this.signedBy;
                if (heldCertificate2 == null) {
                    Intrinsics.throwNpe();
                }
                X500Principal x500Principal = heldCertificate2.certificate().getSubjectX500Principal();
                Intrinsics.checkExpressionValueIsNotNull((Object)x500Principal, (String)"signedBy!!.certificate.subjectX500Principal");
                signedByPrincipal = x500Principal;
            } else {
                signedByKeyPair = heldKeyPair;
                signedByPrincipal = subject;
            }
            long notBefore = this.notBefore != -1L ? this.notBefore : System.currentTimeMillis();
            long notAfter = this.notAfter != -1L ? this.notAfter : notBefore + 86400000L;
            BigInteger serialNumber = this.serialNumber != null ? this.serialNumber : BigInteger.ONE;
            String signatureAlgorithm = signedByKeyPair.getPrivate() instanceof RSAPrivateKey ? "SHA256WithRSA" : "SHA256withECDSA";
            X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
            generator.setSerialNumber(serialNumber);
            generator.setIssuerDN(signedByPrincipal);
            generator.setNotBefore(new Date(notBefore));
            generator.setNotAfter(new Date(notAfter));
            generator.setSubjectDN(subject);
            generator.setPublicKey(heldKeyPair.getPublic());
            generator.setSignatureAlgorithm(signatureAlgorithm);
            if (this.maxIntermediateCas != -1) {
                generator.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(this.maxIntermediateCas));
            }
            Collection collection = this.altNames;
            int n = 0;
            if (!collection.isEmpty()) {
                ASN1Encodable[] encodableAltNames = new ASN1Encodable[this.altNames.size()];
                n = 0;
                int n2 = this.altNames.size();
                while (n < n2) {
                    void i;
                    String altName = this.altNames.get((int)i);
                    int tag = Util.canParseAsIpAddress((String)altName) ? 7 : 2;
                    encodableAltNames[i] = (ASN1Encodable)new GeneralName(tag, altName);
                    ++i;
                }
                generator.addExtension(X509Extensions.SubjectAlternativeName, true, (ASN1Encodable)new DERSequence(encodableAltNames));
            }
            X509Certificate x509Certificate = certificate = generator.generate(signedByKeyPair.getPrivate());
            Intrinsics.checkExpressionValueIsNotNull((Object)x509Certificate, (String)"certificate");
            return new HeldCertificate(heldKeyPair, x509Certificate);
        }

        private final X500Principal buildSubject() {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl4 = false;
            $this$buildString.append("CN=");
            if (this.cn != null) {
                $this$buildString.append(this.cn);
            } else {
                $this$buildString.append(UUID.randomUUID());
            }
            if (this.ou != null) {
                $this$buildString.append(", OU=");
                $this$buildString.append(this.ou);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String name = string;
            return new X500Principal(name);
        }

        private final KeyPair generateKeyPair() {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgorithm);
            keyPairGenerator.initialize(this.keySize, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"keyPairGenerator.generateKeyPair()");
            return keyPair;
        }

        public Builder() {
            List list;
            Builder builder = this;
            boolean bl = false;
            builder.altNames = list = (List)new ArrayList();
            this.maxIntermediateCas = -1;
            this.ecdsa256();
        }

        static {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/tls/HeldCertificate$Builder$Companion;", "", "()V", "DEFAULT_DURATION_MILLIS", "", "okhttp-tls"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lokhttp3/tls/HeldCertificate$Companion;", "", "()V", "PEM_REGEX", "Lkotlin/text/Regex;", "decode", "Lokhttp3/tls/HeldCertificate;", "certificateAndPrivateKeyPem", "", "certificatePem", "pkcs8Base64Text", "decodePem", "Ljava/security/cert/X509Certificate;", "pem", "decodePkcs8", "Ljava/security/PrivateKey;", "data", "Lokio/ByteString;", "keyAlgorithm", "okhttp-tls"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final HeldCertificate decode(@NotNull String certificateAndPrivateKeyPem) {
            Intrinsics.checkParameterIsNotNull((Object)certificateAndPrivateKeyPem, (String)"certificateAndPrivateKeyPem");
            String certificatePem = null;
            String pkcs8Base64 = null;
            for (MatchResult match : Regex.findAll$default((Regex)PEM_REGEX, (CharSequence)certificateAndPrivateKeyPem, (int)0, (int)2, null)) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                String label;
                MatchGroup matchGroup = match.getGroups().get(1);
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(label = matchGroup.getValue()), (Object)"CERTIFICATE")) {
                    bl3 = certificatePem == null;
                    bl2 = false;
                    bl = false;
                    if (!bl3) {
                        boolean bl4 = false;
                        String string = "string includes multiple certificates";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    MatchGroup matchGroup2 = match.getGroups().get(0);
                    if (matchGroup2 == null) {
                        Intrinsics.throwNpe();
                    }
                    certificatePem = matchGroup2.getValue();
                    continue;
                }
                if (Intrinsics.areEqual((Object)label, (Object)"PRIVATE KEY")) {
                    bl3 = pkcs8Base64 == null;
                    bl2 = false;
                    bl = false;
                    if (!bl3) {
                        boolean bl5 = false;
                        String string = "string includes multiple private keys";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    MatchGroup matchGroup3 = match.getGroups().get(2);
                    if (matchGroup3 == null) {
                        Intrinsics.throwNpe();
                    }
                    pkcs8Base64 = matchGroup3.getValue();
                    continue;
                }
                throw (Throwable)new IllegalArgumentException("unexpected type: " + label);
            }
            boolean bl = certificatePem != null;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "string does not include a certificate";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = pkcs8Base64 != null;
            bl6 = false;
            bl7 = false;
            if (!bl) {
                boolean bl9 = false;
                String string = "string does not include a private key";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.decode(certificatePem, pkcs8Base64);
        }

        private final HeldCertificate decode(String certificatePem, String pkcs8Base64Text) {
            Object pkcs8Bytes;
            X509Certificate x509Certificate;
            try {
                x509Certificate = this.decodePem(certificatePem);
            }
            catch (GeneralSecurityException e) {
                throw (Throwable)new IllegalArgumentException("failed to decode certificate", e);
            }
            X509Certificate certificate = x509Certificate;
            try {
                String string;
                ByteString byteString = ByteString.Companion.decodeBase64(pkcs8Base64Text);
                if (byteString == null) {
                    throw (Throwable)new IllegalArgumentException("failed to decode private key");
                }
                pkcs8Bytes = byteString;
                PublicKey publicKey = certificate.getPublicKey();
                if (publicKey instanceof ECPublicKey) {
                    string = "EC";
                } else if (publicKey instanceof RSAPublicKey) {
                    string = "RSA";
                } else {
                    throw (Throwable)new IllegalArgumentException("unexpected key type: " + certificate.getPublicKey());
                }
                String keyType = string;
                pkcs8Bytes = this.decodePkcs8((ByteString)pkcs8Bytes, keyType);
            }
            catch (GeneralSecurityException e) {
                throw (Throwable)new IllegalArgumentException("failed to decode private key", e);
            }
            Object privateKey = pkcs8Bytes;
            KeyPair keyPair = new KeyPair(certificate.getPublicKey(), (PrivateKey)privateKey);
            return new HeldCertificate(keyPair, certificate);
        }

        private final X509Certificate decodePem(String pem) {
            Collection<? extends Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertificates(new Buffer().writeUtf8(pem).inputStream());
            Certificate certificate = certificates.iterator().next();
            if (certificate == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            return (X509Certificate)certificate;
        }

        private final PrivateKey decodePkcs8(ByteString data, String keyAlgorithm) {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(data.toByteArray()));
            Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyFactory.generatePriva\u2026Spec(data.toByteArray()))");
            return privateKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

