/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"certificatePem", "", "Ljava/security/cert/X509Certificate;", "decodeCertificatePem", "encodeBase64Lines", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "data", "Lokio/ByteString;", "okhttp-tls"})
@JvmName(name="Certificates")
public final class Certificates {
    @NotNull
    public static final X509Certificate decodeCertificatePem(@NotNull String $this$decodeCertificatePem) {
        Intrinsics.checkParameterIsNotNull((Object)$this$decodeCertificatePem, (String)"$this$decodeCertificatePem");
        try {
            Collection<? extends Certificate> certificates;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = certificates = certificateFactory.generateCertificates(new Buffer().writeUtf8($this$decodeCertificatePem).inputStream());
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"certificates");
            Object object = CollectionsKt.single((Iterable)collection);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            return (X509Certificate)object;
        }
        catch (NoSuchElementException nsee) {
            throw (Throwable)new CertificateParsingException(nsee);
        }
        catch (IllegalArgumentException iae) {
            throw (Throwable)new CertificateParsingException(iae);
        }
        catch (GeneralSecurityException e) {
            throw (Throwable)new IllegalArgumentException("failed to decode certificate", e);
        }
    }

    @NotNull
    public static final String certificatePem(@NotNull X509Certificate $this$certificatePem) {
        Intrinsics.checkParameterIsNotNull((Object)$this$certificatePem, (String)"$this$certificatePem");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("-----BEGIN CERTIFICATE-----\n");
        byte[] byArray = $this$certificatePem.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"encoded");
        Certificates.encodeBase64Lines($this$buildString, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$buildString.append("-----END CERTIFICATE-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final void encodeBase64Lines(@NotNull StringBuilder $this$encodeBase64Lines, @NotNull ByteString data) {
        Intrinsics.checkParameterIsNotNull((Object)$this$encodeBase64Lines, (String)"$this$encodeBase64Lines");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String base64 = data.base64();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)base64.length())), (int)64);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                void var6_6 = i + 64;
                int n6 = base64.length();
                void var11_11 = i;
                CharSequence charSequence = base64;
                StringBuilder stringBuilder = $this$encodeBase64Lines;
                boolean bl = false;
                int n7 = Math.min((int)var6_6, n6);
                stringBuilder.append(charSequence, (int)var11_11, n7).append('\n');
                if (i == n2) break;
                n = i + n3;
            }
        }
    }
}

