/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.BitString;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0016J\u001f\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u00a2\u0006\u0002\u0010\u001bJ2\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001d0#J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020%J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\"J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\rJ\u000e\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\rJ\u000e\u00103\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u00104\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\"H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lokhttp3/tls/internal/der/DerWriter;", "", "sink", "Lokio/BufferedSink;", "(Lokio/BufferedSink;)V", "constructed", "", "getConstructed", "()Z", "setConstructed", "(Z)V", "path", "", "", "stack", "value", "typeHint", "getTypeHint", "()Ljava/lang/Object;", "setTypeHint", "(Ljava/lang/Object;)V", "typeHintStack", "toString", "withTypeHint", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "write", "", "name", "tagClass", "", "tag", "", "Lkotlin/Function1;", "writeBigInteger", "Ljava/math/BigInteger;", "writeBitString", "bitString", "Lokhttp3/tls/internal/der/BitString;", "writeBoolean", "b", "writeLong", "v", "writeObjectIdentifier", "s", "writeOctetString", "byteString", "Lokio/ByteString;", "writeRelativeObjectIdentifier", "writeUtf8", "writeVariableLengthLong", "okhttp-tls"})
public final class DerWriter {
    @NotNull
    private final List<BufferedSink> stack;
    @NotNull
    private final List<Object> typeHintStack;
    @NotNull
    private final List<String> path;
    private boolean constructed;

    public DerWriter(@NotNull BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Object[] objectArray = new BufferedSink[]{sink};
        this.stack = CollectionsKt.mutableListOf((Object[])objectArray);
        this.typeHintStack = new ArrayList();
        this.path = new ArrayList();
    }

    @Nullable
    public final Object getTypeHint() {
        return CollectionsKt.lastOrNull(this.typeHintStack);
    }

    public final void setTypeHint(@Nullable Object value) {
        this.typeHintStack.set(this.typeHintStack.size() - 1, value);
    }

    public final boolean getConstructed() {
        return this.constructed;
    }

    public final void setConstructed(boolean bl) {
        this.constructed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull String name, int tagClass, long tag, @NotNull Function1<? super BufferedSink, Unit> block) {
        int byte0;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int constructedBit = 0;
        Buffer content = new Buffer();
        this.stack.add((BufferedSink)content);
        this.constructed = false;
        ((Collection)this.path).add(name);
        try {
            block.invoke((Object)content);
            constructedBit = this.constructed ? 32 : 0;
            this.constructed = true;
        }
        finally {
            this.stack.remove(this.stack.size() - 1);
            this.path.remove(this.path.size() - 1);
        }
        BufferedSink sink = this.sink();
        if (tag < 31L) {
            byte0 = tagClass | constructedBit | (int)tag;
            sink.writeByte(byte0);
        } else {
            byte0 = tagClass | constructedBit | 0x1F;
            sink.writeByte(byte0);
            this.writeVariableLengthLong(tag);
        }
        long length = content.size();
        if (length < 128L) {
            sink.writeByte((int)length);
        } else {
            int n;
            int lengthBitCount = 64 - Long.numberOfLeadingZeros(length);
            int lengthByteCount = (lengthBitCount + 7) / 8;
            sink.writeByte(0x80 | lengthByteCount);
            int shift = n = (lengthByteCount - 1) * 8;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-8);
            if (n2 <= shift) {
                while (true) {
                    sink.writeByte((int)(length >> shift));
                    if (shift == n2) break;
                    shift -= 8;
                }
            }
        }
        sink.writeAll((Source)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTypeHint(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.typeHintStack.add(null);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.typeHintStack.remove(this.typeHintStack.size() - 1);
        }
    }

    private final BufferedSink sink() {
        return this.stack.get(this.stack.size() - 1);
    }

    public final void writeBoolean(boolean b) {
        this.sink().writeByte(b ? -1 : 0);
    }

    public final void writeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BufferedSink bufferedSink = this.sink();
        byte[] byArray = value.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        bufferedSink.write(byArray);
    }

    public final void writeLong(long v) {
        int n;
        BufferedSink sink = this.sink();
        int lengthBitCount = v < 0L ? 65 - Long.numberOfLeadingZeros(v ^ 0xFFFFFFFFFFFFFFFFL) : 65 - Long.numberOfLeadingZeros(v);
        int lengthByteCount = (lengthBitCount + 7) / 8;
        int shift = n = (lengthByteCount - 1) * 8;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-8);
        if (n2 <= shift) {
            while (true) {
                sink.writeByte((int)(v >> shift));
                if (shift == n2) break;
                shift -= 8;
            }
        }
    }

    public final void writeBitString(@NotNull BitString bitString) {
        Intrinsics.checkNotNullParameter((Object)bitString, (String)"bitString");
        BufferedSink sink = this.sink();
        sink.writeByte(bitString.getUnusedBitsCount());
        sink.write(bitString.getByteString());
    }

    public final void writeOctetString(@NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        this.sink().write(byteString);
    }

    public final void writeUtf8(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sink().writeUtf8(value);
    }

    public final void writeObjectIdentifier(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Buffer utf8 = new Buffer().writeUtf8(s);
        long v1 = utf8.readDecimalLong();
        if (!(utf8.readByte() == 46)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long v2 = utf8.readDecimalLong();
        this.writeVariableLengthLong(v1 * (long)40 + v2);
        while (!utf8.exhausted()) {
            if (!(utf8.readByte() == 46)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long vN = utf8.readDecimalLong();
            this.writeVariableLengthLong(vN);
        }
    }

    public final void writeRelativeObjectIdentifier(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Buffer utf8 = new Buffer().writeByte(46).writeUtf8(s);
        while (!utf8.exhausted()) {
            if (!(utf8.readByte() == 46)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long vN = utf8.readDecimalLong();
            this.writeVariableLengthLong(vN);
        }
    }

    private final void writeVariableLengthLong(long v) {
        int n;
        BufferedSink sink = this.sink();
        int bitCount = 64 - Long.numberOfLeadingZeros(v);
        int byteCount = (bitCount + 6) / 7;
        int shift = n = (byteCount - 1) * 7;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-7);
        if (n2 <= shift) {
            while (true) {
                int lastBit = shift == 0 ? 0 : 128;
                sink.writeByte((int)(v >> shift & 0x7FL) | lastBit);
                if (shift == n2) break;
                shift -= 7;
            }
        }
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
    }
}

