/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.TlsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\nJ\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0011"}, d2={"Lokhttp3/tls/HandshakeCertificates;", "", "keyManager", "Ljavax/net/ssl/X509KeyManager;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "<init>", "(Ljavax/net/ssl/X509KeyManager;Ljavax/net/ssl/X509TrustManager;)V", "()Ljavax/net/ssl/X509KeyManager;", "()Ljavax/net/ssl/X509TrustManager;", "-deprecated_keyManager", "-deprecated_trustManager", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "sslContext", "Ljavax/net/ssl/SSLContext;", "Builder", "okhttp-tls"})
public final class HandshakeCertificates {
    @NotNull
    private final X509KeyManager keyManager;
    @NotNull
    private final X509TrustManager trustManager;

    private HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    @JvmName(name="keyManager")
    @NotNull
    public final X509KeyManager keyManager() {
        return this.keyManager;
    }

    @JvmName(name="trustManager")
    @NotNull
    public final X509TrustManager trustManager() {
        return this.trustManager;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="keyManager", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_keyManager")
    @NotNull
    public final X509KeyManager -deprecated_keyManager() {
        return this.keyManager;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="trustManager", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_trustManager")
    @NotNull
    public final X509TrustManager -deprecated_trustManager() {
        return this.trustManager;
    }

    @NotNull
    public final SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.sslContext().getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSocketFactory(...)");
        return sSLSocketFactory;
    }

    @NotNull
    public final SSLContext sslContext() {
        SSLContext sSLContext;
        SSLContext $this$sslContext_u24lambda_u240 = sSLContext = Platform.Companion.get().newSSLContext();
        boolean bl = false;
        Object[] objectArray = new KeyManager[]{this.keyManager};
        KeyManager[] keyManagerArray = objectArray;
        objectArray = new TrustManager[]{this.trustManager};
        $this$sslContext_u24lambda_u240.init(keyManagerArray, (TrustManager[])objectArray, new SecureRandom());
        return sSLContext;
    }

    public /* synthetic */ HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager, DefaultConstructorMarker $constructor_marker) {
        this(keyManager, trustManager);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/tls/HandshakeCertificates$Builder;", "", "<init>", "()V", "heldCertificate", "Lokhttp3/tls/HeldCertificate;", "intermediates", "", "Ljava/security/cert/X509Certificate;", "[Ljava/security/cert/X509Certificate;", "trustedCertificates", "", "insecureHosts", "", "(Lokhttp3/tls/HeldCertificate;[Ljava/security/cert/X509Certificate;)Lokhttp3/tls/HandshakeCertificates$Builder;", "addTrustedCertificate", "certificate", "addPlatformTrustedCertificates", "addInsecureHost", "hostname", "build", "Lokhttp3/tls/HandshakeCertificates;", "okhttp-tls"})
    @SourceDebugExtension(value={"SMAP\nHandshakeCertificates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandshakeCertificates.kt\nokhttp3/tls/HandshakeCertificates$Builder\n+ 2 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,192:1\n252#2:193\n37#3:194\n36#3,3:195\n*S KotlinDebug\n*F\n+ 1 HandshakeCertificates.kt\nokhttp3/tls/HandshakeCertificates$Builder\n*L\n179#1:193\n179#1:194\n179#1:195,3\n*E\n"})
    public static final class Builder {
        @Nullable
        private HeldCertificate heldCertificate;
        @Nullable
        private X509Certificate[] intermediates;
        @NotNull
        private final List<X509Certificate> trustedCertificates = new ArrayList();
        @NotNull
        private final List<String> insecureHosts = new ArrayList();

        @NotNull
        public final Builder heldCertificate(@NotNull HeldCertificate heldCertificate, X509Certificate ... intermediates) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)heldCertificate, (String)"heldCertificate");
            Intrinsics.checkNotNullParameter((Object)intermediates, (String)"intermediates");
            Builder $this$heldCertificate_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$heldCertificate_u24lambda_u240.heldCertificate = heldCertificate;
            $this$heldCertificate_u24lambda_u240.intermediates = Arrays.copyOf(intermediates, intermediates.length);
            return builder;
        }

        @NotNull
        public final Builder addTrustedCertificate(@NotNull X509Certificate certificate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Builder $this$addTrustedCertificate_u24lambda_u241 = builder = this;
            boolean bl = false;
            ((Collection)$this$addTrustedCertificate_u24lambda_u241.trustedCertificates).add(certificate);
            return builder;
        }

        @NotNull
        public final Builder addPlatformTrustedCertificates() {
            Builder builder;
            Builder $this$addPlatformTrustedCertificates_u24lambda_u242 = builder = this;
            boolean bl = false;
            X509TrustManager platformTrustManager = Platform.Companion.get().platformTrustManager();
            X509Certificate[] x509CertificateArray = platformTrustManager.getAcceptedIssuers();
            Collections.addAll((Collection)$this$addPlatformTrustedCertificates_u24lambda_u242.trustedCertificates, Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
            return builder;
        }

        @NotNull
        public final Builder addInsecureHost(@NotNull String hostname) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Builder $this$addInsecureHost_u24lambda_u243 = builder = this;
            boolean bl = false;
            ((Collection)$this$addInsecureHost_u24lambda_u243.insecureHosts).add(hostname);
            return builder;
        }

        @NotNull
        public final HandshakeCertificates build() {
            List<String> $this$toImmutableList$iv = this.insecureHosts;
            boolean $i$f$toImmutableList = false;
            X509Certificate[] $this$toTypedArray$iv$iv = (X509Certificate[])$this$toImmutableList$iv;
            boolean $i$f$toTypedArray = false;
            X509Certificate[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            List immutableInsecureHosts = _UtilJvmKt.toImmutableList((Object[])thisCollection$iv$iv.toArray(new String[0]));
            HeldCertificate heldCertificate = this.heldCertificate;
            if (heldCertificate != null && heldCertificate.keyPair().getPrivate().getFormat() == null) {
                throw new KeyStoreException("unable to support unencodable private key");
            }
            X509Certificate[] x509CertificateArray = this.intermediates;
            if (this.intermediates == null) {
                x509CertificateArray = new X509Certificate[]{};
            }
            $this$toTypedArray$iv$iv = x509CertificateArray;
            X509KeyManager keyManager = TlsUtil.newKeyManager(null, heldCertificate, Arrays.copyOf($this$toTypedArray$iv$iv, $this$toTypedArray$iv$iv.length));
            X509TrustManager trustManager = TlsUtil.newTrustManager(null, this.trustedCertificates, immutableInsecureHosts);
            return new HandshakeCertificates(keyManager, trustManager, null);
        }
    }
}

