/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.CertificateAdapters;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.TbsCertificate;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J'\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006+"}, d2={"Lokhttp3/tls/internal/der/Certificate;", "", "tbsCertificate", "Lokhttp3/tls/internal/der/TbsCertificate;", "signatureAlgorithm", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "signatureValue", "Lokhttp3/tls/internal/der/BitString;", "<init>", "(Lokhttp3/tls/internal/der/TbsCertificate;Lokhttp3/tls/internal/der/AlgorithmIdentifier;Lokhttp3/tls/internal/der/BitString;)V", "getTbsCertificate", "()Lokhttp3/tls/internal/der/TbsCertificate;", "getSignatureAlgorithm", "()Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "getSignatureValue", "()Lokhttp3/tls/internal/der/BitString;", "commonName", "getCommonName", "()Ljava/lang/Object;", "organizationalUnitName", "getOrganizationalUnitName", "subjectAlternativeNames", "Lokhttp3/tls/internal/der/Extension;", "getSubjectAlternativeNames", "()Lokhttp3/tls/internal/der/Extension;", "basicConstraints", "getBasicConstraints", "checkSignature", "", "issuer", "Ljava/security/PublicKey;", "toX509Certificate", "Ljava/security/cert/X509Certificate;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "okhttp-tls"})
@SourceDebugExtension(value={"SMAP\nCertificate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Certificate.kt\nokhttp3/tls/internal/der/Certificate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n295#2,2:198\n295#2,2:200\n295#2,2:202\n230#2,2:204\n*S KotlinDebug\n*F\n+ 1 Certificate.kt\nokhttp3/tls/internal/der/Certificate\n*L\n38#1:198,2\n46#1:200,2\n52#1:202,2\n59#1:204,2\n*E\n"})
public final class Certificate {
    @NotNull
    private final TbsCertificate tbsCertificate;
    @NotNull
    private final AlgorithmIdentifier signatureAlgorithm;
    @NotNull
    private final BitString signatureValue;

    public Certificate(@NotNull TbsCertificate tbsCertificate, @NotNull AlgorithmIdentifier signatureAlgorithm, @NotNull BitString signatureValue) {
        Intrinsics.checkNotNullParameter((Object)tbsCertificate, (String)"tbsCertificate");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signatureValue, (String)"signatureValue");
        this.tbsCertificate = tbsCertificate;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureValue = signatureValue;
    }

    @NotNull
    public final TbsCertificate getTbsCertificate() {
        return this.tbsCertificate;
    }

    @NotNull
    public final AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final BitString getSignatureValue() {
        return this.signatureValue;
    }

    @Nullable
    public final Object getCommonName() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.flatten((Iterable)this.tbsCertificate.getSubject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeTypeAndValue it = (AttributeTypeAndValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"2.5.4.3")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AttributeTypeAndValue attributeTypeAndValue = v0;
        return attributeTypeAndValue != null ? attributeTypeAndValue.getValue() : null;
    }

    @Nullable
    public final Object getOrganizationalUnitName() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.flatten((Iterable)this.tbsCertificate.getSubject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeTypeAndValue it = (AttributeTypeAndValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"2.5.4.11")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AttributeTypeAndValue attributeTypeAndValue = v0;
        return attributeTypeAndValue != null ? attributeTypeAndValue.getValue() : null;
    }

    @Nullable
    public final Extension getSubjectAlternativeNames() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.tbsCertificate.getExtensions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Extension it = (Extension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"2.5.29.17")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Extension getBasicConstraints() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tbsCertificate.getExtensions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Extension it = (Extension)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"2.5.29.19")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Extension)element$iv2;
    }

    public final boolean checkSignature(@NotNull PublicKey issuer) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        ByteString signedData = CertificateAdapters.INSTANCE.getTbsCertificate$okhttp_tls().toDer(this.tbsCertificate);
        Signature $this$checkSignature_u24lambda_u244 = Signature.getInstance(this.tbsCertificate.getSignatureAlgorithmName());
        boolean bl = false;
        $this$checkSignature_u24lambda_u244.initVerify(issuer);
        $this$checkSignature_u24lambda_u244.update(signedData.toByteArray());
        return $this$checkSignature_u24lambda_u244.verify(this.signatureValue.getByteString().toByteArray());
    }

    @NotNull
    public final X509Certificate toX509Certificate() {
        ByteString data = CertificateAdapters.INSTANCE.getCertificate$okhttp_tls().toDer(this);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends java.security.cert.Certificate> certificates = certificateFactory.generateCertificates(new Buffer().write(data).inputStream());
            Intrinsics.checkNotNull(certificates);
            Object object = CollectionsKt.single((Iterable)certificates);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            return (X509Certificate)object;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
    }

    @NotNull
    public final TbsCertificate component1() {
        return this.tbsCertificate;
    }

    @NotNull
    public final AlgorithmIdentifier component2() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final BitString component3() {
        return this.signatureValue;
    }

    @NotNull
    public final Certificate copy(@NotNull TbsCertificate tbsCertificate, @NotNull AlgorithmIdentifier signatureAlgorithm, @NotNull BitString signatureValue) {
        Intrinsics.checkNotNullParameter((Object)tbsCertificate, (String)"tbsCertificate");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signatureValue, (String)"signatureValue");
        return new Certificate(tbsCertificate, signatureAlgorithm, signatureValue);
    }

    public static /* synthetic */ Certificate copy$default(Certificate certificate, TbsCertificate tbsCertificate, AlgorithmIdentifier algorithmIdentifier, BitString bitString, int n, Object object) {
        if ((n & 1) != 0) {
            tbsCertificate = certificate.tbsCertificate;
        }
        if ((n & 2) != 0) {
            algorithmIdentifier = certificate.signatureAlgorithm;
        }
        if ((n & 4) != 0) {
            bitString = certificate.signatureValue;
        }
        return certificate.copy(tbsCertificate, algorithmIdentifier, bitString);
    }

    @NotNull
    public String toString() {
        return "Certificate(tbsCertificate=" + this.tbsCertificate + ", signatureAlgorithm=" + this.signatureAlgorithm + ", signatureValue=" + this.signatureValue + ')';
    }

    public int hashCode() {
        int result = this.tbsCertificate.hashCode();
        result = result * 31 + this.signatureAlgorithm.hashCode();
        result = result * 31 + this.signatureValue.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Certificate)) {
            return false;
        }
        Certificate certificate = (Certificate)other;
        if (!Intrinsics.areEqual((Object)this.tbsCertificate, (Object)certificate.tbsCertificate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signatureAlgorithm, (Object)certificate.signatureAlgorithm)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signatureValue, (Object)certificate.signatureValue);
    }
}

