/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.TlsUtil;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u000eR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u0010"}, d2={"Lokhttp3/tls/HandshakeCertificates;", "", "keyManager", "Ljavax/net/ssl/X509KeyManager;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "(Ljavax/net/ssl/X509KeyManager;Ljavax/net/ssl/X509TrustManager;)V", "()Ljavax/net/ssl/X509KeyManager;", "()Ljavax/net/ssl/X509TrustManager;", "-deprecated_keyManager", "sslContext", "Ljavax/net/ssl/SSLContext;", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "-deprecated_trustManager", "Builder", "okhttp-tls"})
public final class HandshakeCertificates {
    @NotNull
    private final X509KeyManager keyManager;
    @NotNull
    private final X509TrustManager trustManager;

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="keyManager"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_keyManager")
    @NotNull
    public final X509KeyManager -deprecated_keyManager() {
        return this.keyManager;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="trustManager"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_trustManager")
    @NotNull
    public final X509TrustManager -deprecated_trustManager() {
        return this.trustManager;
    }

    @NotNull
    public final SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.sslContext().getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext().socketFactory");
        return sSLSocketFactory;
    }

    @NotNull
    public final SSLContext sslContext() {
        SSLContext sSLContext = Platform.Companion.get().newSSLContext();
        boolean bl = false;
        boolean bl2 = false;
        SSLContext $this$apply = sSLContext;
        boolean bl3 = false;
        $this$apply.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, new SecureRandom());
        return sSLContext;
    }

    @JvmName(name="keyManager")
    @NotNull
    public final X509KeyManager keyManager() {
        return this.keyManager;
    }

    @JvmName(name="trustManager")
    @NotNull
    public final X509TrustManager trustManager() {
        return this.trustManager;
    }

    private HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager) {
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    public /* synthetic */ HandshakeCertificates(X509KeyManager keyManager, X509TrustManager trustManager, DefaultConstructorMarker $constructor_marker) {
        this(keyManager, trustManager);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\u0013J'\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/tls/HandshakeCertificates$Builder;", "", "()V", "heldCertificate", "Lokhttp3/tls/HeldCertificate;", "insecureHosts", "", "", "intermediates", "", "Ljava/security/cert/X509Certificate;", "[Ljava/security/cert/X509Certificate;", "trustedCertificates", "addInsecureHost", "hostname", "addPlatformTrustedCertificates", "addTrustedCertificate", "certificate", "build", "Lokhttp3/tls/HandshakeCertificates;", "(Lokhttp3/tls/HeldCertificate;[Ljava/security/cert/X509Certificate;)Lokhttp3/tls/HandshakeCertificates$Builder;", "okhttp-tls"})
    public static final class Builder {
        private HeldCertificate heldCertificate;
        private X509Certificate[] intermediates;
        private final List<X509Certificate> trustedCertificates;
        private final List<String> insecureHosts;

        @NotNull
        public final Builder heldCertificate(@NotNull HeldCertificate heldCertificate, X509Certificate ... intermediates) {
            Intrinsics.checkNotNullParameter((Object)heldCertificate, (String)"heldCertificate");
            Intrinsics.checkNotNullParameter((Object)intermediates, (String)"intermediates");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.heldCertificate = heldCertificate;
            $this$apply.intermediates = Arrays.copyOf(intermediates, intermediates.length);
            return builder;
        }

        @NotNull
        public final Builder addTrustedCertificate(@NotNull X509Certificate certificate2) {
            Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = $this$apply.trustedCertificates;
            X509Certificate x509Certificate = certificate2;
            boolean bl4 = false;
            collection.add(x509Certificate);
            return builder;
        }

        @NotNull
        public final Builder addPlatformTrustedCertificates() {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            X509TrustManager platformTrustManager = Platform.Companion.get().platformTrustManager();
            X509Certificate[] x509CertificateArray = platformTrustManager.getAcceptedIssuers();
            Collections.addAll((Collection)$this$apply.trustedCertificates, Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
            return builder;
        }

        @NotNull
        public final Builder addInsecureHost(@NotNull String hostname) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = $this$apply.insecureHosts;
            String string = hostname;
            boolean bl4 = false;
            collection.add(string);
            return builder;
        }

        @NotNull
        public final HandshakeCertificates build() {
            List immutableInsecureHosts = Util.toImmutableList(this.insecureHosts);
            HeldCertificate heldCertificate = this.heldCertificate;
            if (heldCertificate != null) {
                PrivateKey privateKey = heldCertificate.keyPair().getPrivate();
                Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"heldCertificate.keyPair.private");
                if (privateKey.getFormat() == null) {
                    throw (Throwable)new KeyStoreException("unable to support unencodable private key");
                }
            }
            X509Certificate[] x509CertificateArray = this.intermediates;
            if (this.intermediates == null) {
                x509CertificateArray = new X509Certificate[]{};
            }
            X509KeyManager keyManager = TlsUtil.newKeyManager(null, heldCertificate, Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
            X509TrustManager trustManager = TlsUtil.newTrustManager(null, this.trustedCertificates, immutableInsecureHosts);
            return new HandshakeCertificates(keyManager, trustManager, null);
        }

        public Builder() {
            boolean bl = false;
            this.trustedCertificates = new ArrayList();
            bl = false;
            this.insecureHosts = new ArrayList();
        }
    }
}

