/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;
import okhttp3.tls.internal.InsecureAndroidTrustManager;
import okhttp3.tls.internal.InsecureExtendedTrustManager;
import okhttp3.tls.internal.TlsUtil;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J5\u0010\u0011\u001a\u00020\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J.\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lokhttp3/tls/internal/TlsUtil;", "", "()V", "localhost", "Lokhttp3/tls/HandshakeCertificates;", "getLocalhost", "()Lokhttp3/tls/HandshakeCertificates;", "localhost$delegate", "Lkotlin/Lazy;", "password", "", "getPassword", "()[C", "newEmptyKeyStore", "Ljava/security/KeyStore;", "keyStoreType", "", "newKeyManager", "Ljavax/net/ssl/X509KeyManager;", "heldCertificate", "Lokhttp3/tls/HeldCertificate;", "intermediates", "", "Ljava/security/cert/X509Certificate;", "(Ljava/lang/String;Lokhttp3/tls/HeldCertificate;[Ljava/security/cert/X509Certificate;)Ljavax/net/ssl/X509KeyManager;", "newTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustedCertificates", "", "insecureHosts", "okhttp-tls"})
public final class TlsUtil {
    @NotNull
    private static final char[] password;
    private static final Lazy localhost$delegate;
    @NotNull
    public static final TlsUtil INSTANCE;

    @NotNull
    public final char[] getPassword() {
        return password;
    }

    private final HandshakeCertificates getLocalhost() {
        Lazy lazy = localhost$delegate;
        TlsUtil tlsUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (HandshakeCertificates)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final HandshakeCertificates localhost() {
        return INSTANCE.getLocalhost();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @IgnoreJRERequirement
    @NotNull
    public static final X509TrustManager newTrustManager(@Nullable String keyStoreType, @NotNull List<? extends X509Certificate> trustedCertificates, @NotNull List<String> insecureHosts) {
        X509TrustManager x509TrustManager;
        Intrinsics.checkNotNullParameter(trustedCertificates, (String)"trustedCertificates");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        KeyStore trustStore = INSTANCE.newEmptyKeyStore(keyStoreType);
        int n = 0;
        int n2 = ((Collection)trustedCertificates).size();
        while (n < n2) {
            void i;
            trustStore.setCertificateEntry("cert_" + (int)i, trustedCertificates.get((int)i));
            ++i;
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(trustStore);
        TrustManagerFactory trustManagerFactory = factory;
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerFactory, (String)"factory");
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] result = objectArray;
        boolean bl = result.length == 1 && result[0] instanceof X509TrustManager;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected trust managers: ");
            Object[] objectArray2 = result;
            boolean bl5 = false;
            String string = Arrays.toString(objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            String string2 = stringBuilder.append(string).toString();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        TrustManager trustManager = result[0];
        if (trustManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        X509TrustManager trustManager2 = (X509TrustManager)trustManager;
        if (insecureHosts.isEmpty()) {
            x509TrustManager = trustManager2;
        } else if (Platform.Companion.isAndroid()) {
            x509TrustManager = new InsecureAndroidTrustManager(trustManager2, insecureHosts);
        } else {
            X509TrustManager x509TrustManager2 = trustManager2;
            if (x509TrustManager2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509ExtendedTrustManager");
            }
            x509TrustManager = new InsecureExtendedTrustManager((X509ExtendedTrustManager)x509TrustManager2, insecureHosts);
        }
        return x509TrustManager;
    }

    @JvmStatic
    @NotNull
    public static final X509KeyManager newKeyManager(@Nullable String keyStoreType, @Nullable HeldCertificate heldCertificate, X509Certificate ... intermediates) {
        Intrinsics.checkNotNullParameter((Object)intermediates, (String)"intermediates");
        KeyStore keyStore = INSTANCE.newEmptyKeyStore(keyStoreType);
        if (heldCertificate != null) {
            Object[] chain = new Certificate[1 + intermediates.length];
            chain[0] = heldCertificate.certificate();
            ArraysKt.copyInto$default((Object[])intermediates, (Object[])chain, (int)1, (int)0, (int)0, (int)12, null);
            keyStore.setKeyEntry("private", heldCertificate.keyPair().getPrivate(), password, (Certificate[])chain);
        }
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore, password);
        KeyManagerFactory keyManagerFactory = factory;
        Intrinsics.checkNotNullExpressionValue((Object)keyManagerFactory, (String)"factory");
        Object[] objectArray = keyManagerFactory.getKeyManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] result = objectArray;
        boolean bl = result.length == 1 && result[0] instanceof X509KeyManager;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected key managers:");
            Object[] objectArray2 = result;
            boolean bl5 = false;
            String string = Arrays.toString(objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            String string2 = stringBuilder.append(string).toString();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        KeyManager keyManager = result[0];
        if (keyManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509KeyManager");
        }
        return (X509KeyManager)keyManager;
    }

    private final KeyStore newEmptyKeyStore(String keyStoreType) {
        String string = keyStoreType;
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        KeyStore keyStore = KeyStore.getInstance(string);
        boolean bl = false;
        boolean bl2 = false;
        KeyStore $this$apply = keyStore;
        boolean bl3 = false;
        InputStream inputStream = null;
        $this$apply.load(inputStream, password);
        KeyStore keyStore2 = keyStore;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"KeyStore.getInstance(key\u2026utStream, password)\n    }");
        return keyStore2;
    }

    private TlsUtil() {
    }

    static {
        TlsUtil tlsUtil;
        INSTANCE = tlsUtil = new TlsUtil();
        String string = "password";
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        password = cArray;
        localhost$delegate = LazyKt.lazy((Function0)localhost.2.INSTANCE);
    }
}

