/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.CertificateAdapters;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.TbsCertificate;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J'\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0006\u0010(\u001a\u00020)R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lokhttp3/tls/internal/der/Certificate;", "", "tbsCertificate", "Lokhttp3/tls/internal/der/TbsCertificate;", "signatureAlgorithm", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "signatureValue", "Lokhttp3/tls/internal/der/BitString;", "(Lokhttp3/tls/internal/der/TbsCertificate;Lokhttp3/tls/internal/der/AlgorithmIdentifier;Lokhttp3/tls/internal/der/BitString;)V", "basicConstraints", "Lokhttp3/tls/internal/der/Extension;", "getBasicConstraints", "()Lokhttp3/tls/internal/der/Extension;", "commonName", "getCommonName", "()Ljava/lang/Object;", "organizationalUnitName", "getOrganizationalUnitName", "getSignatureAlgorithm", "()Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "getSignatureValue", "()Lokhttp3/tls/internal/der/BitString;", "subjectAlternativeNames", "getSubjectAlternativeNames", "getTbsCertificate", "()Lokhttp3/tls/internal/der/TbsCertificate;", "checkSignature", "", "issuer", "Ljava/security/PublicKey;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "toX509Certificate", "Ljava/security/cert/X509Certificate;", "okhttp-tls"})
public final class Certificate {
    @NotNull
    private final TbsCertificate tbsCertificate;
    @NotNull
    private final AlgorithmIdentifier signatureAlgorithm;
    @NotNull
    private final BitString signatureValue;

    public Certificate(@NotNull TbsCertificate tbsCertificate2, @NotNull AlgorithmIdentifier signatureAlgorithm, @NotNull BitString signatureValue) {
        Intrinsics.checkNotNullParameter((Object)tbsCertificate2, (String)"tbsCertificate");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signatureValue, (String)"signatureValue");
        this.tbsCertificate = tbsCertificate2;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureValue = signatureValue;
    }

    @NotNull
    public final TbsCertificate getTbsCertificate() {
        return this.tbsCertificate;
    }

    @NotNull
    public final AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final BitString getSignatureValue() {
        return this.signatureValue;
    }

    @Nullable
    public final Object getCommonName() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.flatten((Iterable)this.tbsCertificate.getSubject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeTypeAndValue it = (AttributeTypeAndValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"2.5.4.3")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AttributeTypeAndValue attributeTypeAndValue2 = v0;
        return attributeTypeAndValue2 == null ? null : attributeTypeAndValue2.getValue();
    }

    @Nullable
    public final Object getOrganizationalUnitName() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.flatten((Iterable)this.tbsCertificate.getSubject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeTypeAndValue it = (AttributeTypeAndValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"2.5.4.11")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AttributeTypeAndValue attributeTypeAndValue2 = v0;
        return attributeTypeAndValue2 == null ? null : attributeTypeAndValue2.getValue();
    }

    @Nullable
    public final Extension getSubjectAlternativeNames() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.tbsCertificate.getExtensions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Extension it = (Extension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"2.5.29.17")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Extension getBasicConstraints() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tbsCertificate.getExtensions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Extension it = (Extension)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"2.5.29.19")) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Extension)element$iv2;
    }

    public final boolean checkSignature(@NotNull PublicKey issuer) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        ByteString signedData = CertificateAdapters.INSTANCE.getTbsCertificate$okhttp_tls().toDer(this.tbsCertificate);
        Signature signature = Signature.getInstance(this.tbsCertificate.getSignatureAlgorithmName());
        boolean bl = false;
        boolean bl2 = false;
        Signature $this$checkSignature_u24lambda_u2d4 = signature;
        boolean bl3 = false;
        $this$checkSignature_u24lambda_u2d4.initVerify(issuer);
        $this$checkSignature_u24lambda_u2d4.update(signedData.toByteArray());
        return $this$checkSignature_u24lambda_u2d4.verify(this.getSignatureValue().getByteString().toByteArray());
    }

    @NotNull
    public final X509Certificate toX509Certificate() {
        ByteString data = CertificateAdapters.INSTANCE.getCertificate$okhttp_tls().toDer(this);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends java.security.cert.Certificate> certificates = certificateFactory.generateCertificates(new Buffer().write(data).inputStream());
            Intrinsics.checkNotNullExpressionValue(certificates, (String)"certificates");
            Object object = CollectionsKt.single((Iterable)certificates);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            return (X509Certificate)object;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
    }

    @NotNull
    public final TbsCertificate component1() {
        return this.tbsCertificate;
    }

    @NotNull
    public final AlgorithmIdentifier component2() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final BitString component3() {
        return this.signatureValue;
    }

    @NotNull
    public final Certificate copy(@NotNull TbsCertificate tbsCertificate2, @NotNull AlgorithmIdentifier signatureAlgorithm, @NotNull BitString signatureValue) {
        Intrinsics.checkNotNullParameter((Object)tbsCertificate2, (String)"tbsCertificate");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signatureValue, (String)"signatureValue");
        return new Certificate(tbsCertificate2, signatureAlgorithm, signatureValue);
    }

    public static /* synthetic */ Certificate copy$default(Certificate certificate2, TbsCertificate tbsCertificate2, AlgorithmIdentifier algorithmIdentifier2, BitString bitString, int n, Object object) {
        if ((n & 1) != 0) {
            tbsCertificate2 = certificate2.tbsCertificate;
        }
        if ((n & 2) != 0) {
            algorithmIdentifier2 = certificate2.signatureAlgorithm;
        }
        if ((n & 4) != 0) {
            bitString = certificate2.signatureValue;
        }
        return certificate2.copy(tbsCertificate2, algorithmIdentifier2, bitString);
    }

    @NotNull
    public String toString() {
        return "Certificate(tbsCertificate=" + this.tbsCertificate + ", signatureAlgorithm=" + this.signatureAlgorithm + ", signatureValue=" + this.signatureValue + ')';
    }

    public int hashCode() {
        int result = this.tbsCertificate.hashCode();
        result = result * 31 + this.signatureAlgorithm.hashCode();
        result = result * 31 + this.signatureValue.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Certificate)) {
            return false;
        }
        Certificate certificate2 = (Certificate)other;
        if (!Intrinsics.areEqual((Object)this.tbsCertificate, (Object)certificate2.tbsCertificate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signatureAlgorithm, (Object)certificate2.signatureAlgorithm)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signatureValue, (Object)certificate2.signatureValue);
    }
}

