/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.math.BigInteger;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import okhttp3.internal._HostnamesCommonKt;
import okhttp3.tls.Certificates;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BasicConstraints;
import okhttp3.tls.internal.der.BasicDerAdapter;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.Certificate;
import okhttp3.tls.internal.der.CertificateAdapters;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.PrivateKeyInfo;
import okhttp3.tls.internal.der.SubjectPublicKeyInfo;
import okhttp3.tls.internal.der.TbsCertificate;
import okhttp3.tls.internal.der.Validity;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\u000bJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\u0013"}, d2={"Lokhttp3/tls/HeldCertificate;", "", "keyPair", "Ljava/security/KeyPair;", "certificate", "Ljava/security/cert/X509Certificate;", "(Ljava/security/KeyPair;Ljava/security/cert/X509Certificate;)V", "()Ljava/security/cert/X509Certificate;", "()Ljava/security/KeyPair;", "-deprecated_certificate", "certificatePem", "", "-deprecated_keyPair", "pkcs1Bytes", "Lokio/ByteString;", "privateKeyPkcs1Pem", "privateKeyPkcs8Pem", "Builder", "Companion", "okhttp-tls"})
public final class HeldCertificate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyPair keyPair;
    @NotNull
    private final X509Certificate certificate;
    @NotNull
    private static final Regex PEM_REGEX = new Regex("-----BEGIN ([!-,.-~ ]*)-----([^-]*)-----END \\1-----");

    public HeldCertificate(@NotNull KeyPair keyPair, @NotNull X509Certificate certificate2) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
        this.keyPair = keyPair;
        this.certificate = certificate2;
    }

    @JvmName(name="keyPair")
    @NotNull
    public final KeyPair keyPair() {
        return this.keyPair;
    }

    @JvmName(name="certificate")
    @NotNull
    public final X509Certificate certificate() {
        return this.certificate;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="certificate", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_certificate")
    @NotNull
    public final X509Certificate -deprecated_certificate() {
        return this.certificate;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="keyPair", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_keyPair")
    @NotNull
    public final KeyPair -deprecated_keyPair() {
        return this.keyPair;
    }

    @NotNull
    public final String certificatePem() {
        return Certificates.certificatePem(this.certificate);
    }

    @NotNull
    public final String privateKeyPkcs8Pem() {
        StringBuilder stringBuilder;
        StringBuilder $this$privateKeyPkcs8Pem_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$privateKeyPkcs8Pem_u24lambda_u2d0.append("-----BEGIN PRIVATE KEY-----\n");
        byte[] byArray = this.keyPair().getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.private.encoded");
        Certificates.encodeBase64Lines($this$privateKeyPkcs8Pem_u24lambda_u2d0, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$privateKeyPkcs8Pem_u24lambda_u2d0.append("-----END PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String privateKeyPkcs1Pem() {
        StringBuilder stringBuilder;
        if (!(this.keyPair.getPrivate() instanceof RSAPrivateKey)) {
            boolean $i$a$-check-HeldCertificate$privateKeyPkcs1Pem$22 = false;
            String $i$a$-check-HeldCertificate$privateKeyPkcs1Pem$22 = "PKCS1 only supports RSA keys";
            throw new IllegalStateException($i$a$-check-HeldCertificate$privateKeyPkcs1Pem$22.toString());
        }
        StringBuilder $this$privateKeyPkcs1Pem_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$privateKeyPkcs1Pem_u24lambda_u2d2.append("-----BEGIN RSA PRIVATE KEY-----\n");
        Certificates.encodeBase64Lines($this$privateKeyPkcs1Pem_u24lambda_u2d2, this.pkcs1Bytes());
        $this$privateKeyPkcs1Pem_u24lambda_u2d2.append("-----END RSA PRIVATE KEY-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final ByteString pkcs1Bytes() {
        BasicDerAdapter<PrivateKeyInfo> basicDerAdapter = CertificateAdapters.INSTANCE.getPrivateKeyInfo$okhttp_tls();
        byte[] byArray = this.keyPair.getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.private.encoded");
        PrivateKeyInfo decoded = basicDerAdapter.fromDer(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        return decoded.getPrivateKey();
    }

    @JvmStatic
    @NotNull
    public static final HeldCertificate decode(@NotNull String certificateAndPrivateKeyPem) {
        return Companion.decode(certificateAndPrivateKeyPem);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005J\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0004H\u0002J\b\u0010 \u001a\u00020\tH\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0014\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0+H\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lokhttp3/tls/HeldCertificate$Builder;", "", "()V", "altNames", "", "", "commonName", "keyAlgorithm", "keyPair", "Ljava/security/KeyPair;", "keySize", "", "maxIntermediateCas", "notAfter", "", "notBefore", "organizationalUnit", "serialNumber", "Ljava/math/BigInteger;", "signedBy", "Lokhttp3/tls/HeldCertificate;", "addSubjectAlternativeName", "altName", "build", "certificateAuthority", "cn", "duration", "unit", "Ljava/util/concurrent/TimeUnit;", "ecdsa256", "extensions", "Lokhttp3/tls/internal/der/Extension;", "generateKeyPair", "publicKey", "Ljava/security/PublicKey;", "privateKey", "Ljava/security/PrivateKey;", "ou", "rsa2048", "signatureAlgorithm", "Lokhttp3/tls/internal/der/AlgorithmIdentifier;", "signedByKeyPair", "subject", "", "Lokhttp3/tls/internal/der/AttributeTypeAndValue;", "validity", "Lokhttp3/tls/internal/der/Validity;", "validityInterval", "Companion", "okhttp-tls"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private long notBefore = -1L;
        private long notAfter = -1L;
        @Nullable
        private String commonName;
        @Nullable
        private String organizationalUnit;
        @NotNull
        private final List<String> altNames = new ArrayList();
        @Nullable
        private BigInteger serialNumber;
        @Nullable
        private KeyPair keyPair;
        @Nullable
        private HeldCertificate signedBy;
        private int maxIntermediateCas = -1;
        @Nullable
        private String keyAlgorithm;
        private int keySize;
        private static final long DEFAULT_DURATION_MILLIS = 86400000L;

        public Builder() {
            this.ecdsa256();
        }

        @NotNull
        public final Builder validityInterval(long notBefore, long notAfter) {
            Builder builder;
            Builder $this$validityInterval_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            if (!(notBefore <= notAfter && notBefore == -1L == (notAfter == -1L))) {
                boolean bl2 = false;
                String string = "invalid interval: " + notBefore + ".." + notAfter;
                throw new IllegalArgumentException(string.toString());
            }
            $this$validityInterval_u24lambda_u2d1.notBefore = notBefore;
            $this$validityInterval_u24lambda_u2d1.notAfter = notAfter;
            return builder;
        }

        @NotNull
        public final Builder duration(long duration, @NotNull TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            Builder $this$duration_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            long now = System.currentTimeMillis();
            $this$duration_u24lambda_u2d2.validityInterval(now, now + unit.toMillis(duration));
            return builder;
        }

        @NotNull
        public final Builder addSubjectAlternativeName(@NotNull String altName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)altName, (String)"altName");
            Builder $this$addSubjectAlternativeName_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            ((Collection)$this$addSubjectAlternativeName_u24lambda_u2d3.altNames).add(altName);
            return builder;
        }

        @NotNull
        public final Builder commonName(@NotNull String cn) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)cn, (String)"cn");
            Builder $this$commonName_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$commonName_u24lambda_u2d4.commonName = cn;
            return builder;
        }

        @NotNull
        public final Builder organizationalUnit(@NotNull String ou) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)ou, (String)"ou");
            Builder $this$organizationalUnit_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$organizationalUnit_u24lambda_u2d5.organizationalUnit = ou;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(@NotNull BigInteger serialNumber) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
            Builder $this$serialNumber_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$serialNumber_u24lambda_u2d6.serialNumber = serialNumber;
            return builder;
        }

        @NotNull
        public final Builder serialNumber(long serialNumber) {
            Builder builder;
            Builder $this$serialNumber_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            BigInteger bigInteger = BigInteger.valueOf(serialNumber);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(serialNumber)");
            $this$serialNumber_u24lambda_u2d7.serialNumber(bigInteger);
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull KeyPair keyPair) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Builder $this$keyPair_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$keyPair_u24lambda_u2d8.keyPair = keyPair;
            return builder;
        }

        @NotNull
        public final Builder keyPair(@NotNull PublicKey publicKey, @NotNull PrivateKey privateKey) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Builder $this$keyPair_u24lambda_u2d9 = builder = this;
            boolean bl = false;
            $this$keyPair_u24lambda_u2d9.keyPair(new KeyPair(publicKey, privateKey));
            return builder;
        }

        @NotNull
        public final Builder signedBy(@Nullable HeldCertificate signedBy) {
            Builder builder;
            Builder $this$signedBy_u24lambda_u2d10 = builder = this;
            boolean bl = false;
            $this$signedBy_u24lambda_u2d10.signedBy = signedBy;
            return builder;
        }

        @NotNull
        public final Builder certificateAuthority(int maxIntermediateCas) {
            Builder builder;
            Builder $this$certificateAuthority_u24lambda_u2d12 = builder = this;
            boolean bl = false;
            if (!(maxIntermediateCas >= 0)) {
                boolean bl2 = false;
                String string = Intrinsics.stringPlus((String)"maxIntermediateCas < 0: ", (Object)maxIntermediateCas);
                throw new IllegalArgumentException(string.toString());
            }
            $this$certificateAuthority_u24lambda_u2d12.maxIntermediateCas = maxIntermediateCas;
            return builder;
        }

        @NotNull
        public final Builder ecdsa256() {
            Builder builder;
            Builder $this$ecdsa256_u24lambda_u2d13 = builder = this;
            boolean bl = false;
            $this$ecdsa256_u24lambda_u2d13.keyAlgorithm = "EC";
            $this$ecdsa256_u24lambda_u2d13.keySize = 256;
            return builder;
        }

        @NotNull
        public final Builder rsa2048() {
            Builder builder;
            Builder $this$rsa2048_u24lambda_u2d14 = builder = this;
            boolean bl = false;
            $this$rsa2048_u24lambda_u2d14.keyAlgorithm = "RSA";
            $this$rsa2048_u24lambda_u2d14.keySize = 2048;
            return builder;
        }

        @NotNull
        public final HeldCertificate build() {
            KeyPair keyPair = this.keyPair;
            if (keyPair == null) {
                keyPair = this.generateKeyPair();
            }
            KeyPair subjectKeyPair = keyPair;
            BasicDerAdapter<SubjectPublicKeyInfo> basicDerAdapter = CertificateAdapters.INSTANCE.getSubjectPublicKeyInfo$okhttp_tls();
            byte[] byArray = subjectKeyPair.getPublic().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"subjectKeyPair.public.encoded");
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = basicDerAdapter.fromDer(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
            List<List<AttributeTypeAndValue>> subject = this.subject();
            KeyPair issuerKeyPair = null;
            List<List<AttributeTypeAndValue>> issuer = null;
            if (this.signedBy != null) {
                HeldCertificate heldCertificate = this.signedBy;
                Intrinsics.checkNotNull((Object)heldCertificate);
                issuerKeyPair = heldCertificate.keyPair();
                BasicDerAdapter<List<List<AttributeTypeAndValue>>> basicDerAdapter2 = CertificateAdapters.INSTANCE.getRdnSequence$okhttp_tls();
                HeldCertificate heldCertificate2 = this.signedBy;
                Intrinsics.checkNotNull((Object)heldCertificate2);
                byte[] byArray2 = heldCertificate2.certificate().getSubjectX500Principal().getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"signedBy!!.certificate.s\u2026jectX500Principal.encoded");
                issuer = basicDerAdapter2.fromDer(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray2, (int)0, (int)0, (int)3, null));
            } else {
                issuerKeyPair = subjectKeyPair;
                issuer = subject;
            }
            AlgorithmIdentifier signatureAlgorithm = this.signatureAlgorithm(issuerKeyPair);
            BigInteger bigInteger = this.serialNumber;
            if (bigInteger == null) {
                bigInteger = BigInteger.ONE;
            }
            BigInteger bigInteger2 = bigInteger;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"serialNumber ?: BigInteger.ONE");
            TbsCertificate tbsCertificate2 = new TbsCertificate(2L, bigInteger2, signatureAlgorithm, issuer, this.validity(), subject, subjectPublicKeyInfo2, null, null, this.extensions());
            Signature $this$build_u24lambda_u2d15 = Signature.getInstance(tbsCertificate2.getSignatureAlgorithmName());
            boolean bl = false;
            $this$build_u24lambda_u2d15.initSign(issuerKeyPair.getPrivate());
            $this$build_u24lambda_u2d15.update(CertificateAdapters.INSTANCE.getTbsCertificate$okhttp_tls().toDer(tbsCertificate2).toByteArray());
            byte[] byArray3 = $this$build_u24lambda_u2d15.sign();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"sign()");
            ByteString signature = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray3, (int)0, (int)0, (int)3, null);
            Certificate certificate2 = new Certificate(tbsCertificate2, signatureAlgorithm, new BitString(signature, 0));
            return new HeldCertificate(subjectKeyPair, certificate2.toX509Certificate());
        }

        private final List<List<AttributeTypeAndValue>> subject() {
            List result = new ArrayList();
            if (this.organizationalUnit != null) {
                ((Collection)result).add(CollectionsKt.listOf((Object)new AttributeTypeAndValue("2.5.4.11", this.organizationalUnit)));
            }
            Collection collection = result;
            String string = this.commonName;
            if (string == null) {
                String string2 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
                string = string2;
            }
            collection.add(CollectionsKt.listOf((Object)new AttributeTypeAndValue("2.5.4.3", string)));
            return result;
        }

        private final Validity validity() {
            long notBefore = this.notBefore != -1L ? this.notBefore : System.currentTimeMillis();
            long notAfter = this.notAfter != -1L ? this.notAfter : notBefore + 86400000L;
            return new Validity(notBefore, notAfter);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Extension> extensions() {
            List result = new ArrayList();
            if (this.maxIntermediateCas != -1) {
                ((Collection)result).add(new Extension("2.5.29.19", true, new BasicConstraints(true, Long.valueOf(this.maxIntermediateCas))));
            }
            if (!((Collection)this.altNames).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.altNames;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair;
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (_HostnamesCommonKt.canParseAsIpAddress((String)it)) {
                        BasicDerAdapter<ByteString> basicDerAdapter = CertificateAdapters.INSTANCE.getGeneralNameIpAddress$okhttp_tls();
                        byte[] byArray = InetAddress.getByName((String)it).getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getByName(it).address");
                        pair = TuplesKt.to(basicDerAdapter, (Object)ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
                    } else {
                        pair = TuplesKt.to(CertificateAdapters.INSTANCE.getGeneralNameDnsName$okhttp_tls(), (Object)it);
                    }
                    collection.add(pair);
                }
                List extensionValue2 = (List)destination$iv$iv;
                ((Collection)result).add(new Extension("2.5.29.17", true, extensionValue2));
            }
            return result;
        }

        private final AlgorithmIdentifier signatureAlgorithm(KeyPair signedByKeyPair) {
            return signedByKeyPair.getPrivate() instanceof RSAPrivateKey ? new AlgorithmIdentifier("1.2.840.113549.1.1.11", null) : new AlgorithmIdentifier("1.2.840.10045.4.3.2", ByteString.EMPTY);
        }

        private final KeyPair generateKeyPair() {
            KeyPairGenerator $this$generateKeyPair_u24lambda_u2d17 = KeyPairGenerator.getInstance(this.keyAlgorithm);
            boolean bl = false;
            $this$generateKeyPair_u24lambda_u2d17.initialize(this.keySize, new SecureRandom());
            KeyPair keyPair = $this$generateKeyPair_u24lambda_u2d17.generateKeyPair();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"getInstance(keyAlgorithm\u2026generateKeyPair()\n      }");
            return keyPair;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/tls/HeldCertificate$Builder$Companion;", "", "()V", "DEFAULT_DURATION_MILLIS", "", "okhttp-tls"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/tls/HeldCertificate$Companion;", "", "()V", "PEM_REGEX", "Lkotlin/text/Regex;", "decode", "Lokhttp3/tls/HeldCertificate;", "certificateAndPrivateKeyPem", "", "certificatePem", "pkcs8Base64Text", "decodePkcs8", "Ljava/security/PrivateKey;", "data", "Lokio/ByteString;", "keyAlgorithm", "okhttp-tls"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HeldCertificate decode(@NotNull String certificateAndPrivateKeyPem) {
            Intrinsics.checkNotNullParameter((Object)certificateAndPrivateKeyPem, (String)"certificateAndPrivateKeyPem");
            String certificatePem = null;
            String pkcs8Base64 = null;
            for (MatchResult match : Regex.findAll$default((Regex)PEM_REGEX, (CharSequence)certificateAndPrivateKeyPem, (int)0, (int)2, null)) {
                MatchGroup matchGroup = match.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String label = matchGroup.getValue();
                if (Intrinsics.areEqual((Object)label, (Object)"CERTIFICATE")) {
                    if (!(certificatePem == null)) {
                        boolean $i$a$-require-HeldCertificate$Companion$decode$52 = false;
                        String $i$a$-require-HeldCertificate$Companion$decode$52 = "string includes multiple certificates";
                        throw new IllegalArgumentException($i$a$-require-HeldCertificate$Companion$decode$52.toString());
                    }
                    MatchGroup matchGroup2 = match.getGroups().get(0);
                    Intrinsics.checkNotNull((Object)matchGroup2);
                    certificatePem = matchGroup2.getValue();
                    continue;
                }
                if (Intrinsics.areEqual((Object)label, (Object)"PRIVATE KEY")) {
                    if (!(pkcs8Base64 == null)) {
                        boolean bl = false;
                        String string = "string includes multiple private keys";
                        throw new IllegalArgumentException(string.toString());
                    }
                    MatchGroup matchGroup3 = match.getGroups().get(2);
                    Intrinsics.checkNotNull((Object)matchGroup3);
                    pkcs8Base64 = matchGroup3.getValue();
                    continue;
                }
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unexpected type: ", (Object)label));
            }
            if (!(certificatePem != null)) {
                boolean $i$a$-require-HeldCertificate$Companion$decode$62 = false;
                String $i$a$-require-HeldCertificate$Companion$decode$62 = "string does not include a certificate";
                throw new IllegalArgumentException($i$a$-require-HeldCertificate$Companion$decode$62.toString());
            }
            if (!(pkcs8Base64 != null)) {
                boolean bl = false;
                String string = "string does not include a private key";
                throw new IllegalArgumentException(string.toString());
            }
            return this.decode(certificatePem, pkcs8Base64);
        }

        private final HeldCertificate decode(String certificatePem, String pkcs8Base64Text) {
            String string;
            X509Certificate certificate2 = Certificates.decodeCertificatePem(certificatePem);
            ByteString byteString = ByteString.Companion.decodeBase64(pkcs8Base64Text);
            if (byteString == null) {
                throw new IllegalArgumentException("failed to decode private key");
            }
            ByteString pkcs8Bytes = byteString;
            PublicKey publicKey = certificate2.getPublicKey();
            if (publicKey instanceof ECPublicKey) {
                string = "EC";
            } else if (publicKey instanceof RSAPublicKey) {
                string = "RSA";
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unexpected key type: ", (Object)certificate2.getPublicKey()));
            }
            String keyType = string;
            PrivateKey privateKey = this.decodePkcs8(pkcs8Bytes, keyType);
            KeyPair keyPair = new KeyPair(certificate2.getPublicKey(), privateKey);
            return new HeldCertificate(keyPair, certificate2);
        }

        private final PrivateKey decodePkcs8(ByteString data, String keyAlgorithm) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
                PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(data.toByteArray()));
                Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory.generatePriva\u2026Spec(data.toByteArray()))");
                return privateKey;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("failed to decode private key", e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

