/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.math.BigInteger;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.DerHeader;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001d\u001a\u00020\fJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014J7\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\b\u0010!\u001a\u0004\u0018\u00010\u00122\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H 0#H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\fJ\r\u0010+\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b,J\u0006\u0010-\u001a\u00020\u0006J\u0006\u0010.\u001a\u00020\u0012J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0012J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u00020\u0012J\b\u00104\u001a\u00020\u0006H\u0002J\b\u00105\u001a\u00020\u0012H\u0016J\u001f\u00106\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 07\u00a2\u0006\u0002\u00108R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006;"}, d2={"Lokhttp3/tls/internal/der/DerReader;", "", "source", "Lokio/Source;", "(Lokio/Source;)V", "byteCount", "", "getByteCount", "()J", "bytesLeft", "getBytesLeft", "constructed", "", "countingSource", "Lokhttp3/tls/internal/der/DerReader$CountingSource;", "limit", "path", "", "", "peekedHeader", "Lokhttp3/tls/internal/der/DerHeader;", "Lokio/BufferedSource;", "value", "typeHint", "getTypeHint", "()Ljava/lang/Object;", "setTypeHint", "(Ljava/lang/Object;)V", "typeHintStack", "hasNext", "peekHeader", "read", "T", "name", "block", "Lkotlin/Function1;", "read$okhttp_tls", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readBigInteger", "Ljava/math/BigInteger;", "readBitString", "Lokhttp3/tls/internal/der/BitString;", "readBoolean", "readHeader", "readHeader$okhttp_tls", "readLong", "readObjectIdentifier", "readOctetString", "Lokio/ByteString;", "readRelativeObjectIdentifier", "readUnknown", "readUtf8String", "readVariableLengthLong", "toString", "withTypeHint", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "CountingSource", "okhttp-tls"})
public final class DerReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CountingSource countingSource;
    @NotNull
    private final BufferedSource source;
    private long limit;
    @NotNull
    private final List<Object> typeHintStack;
    @NotNull
    private final List<String> path;
    private boolean constructed;
    @Nullable
    private DerHeader peekedHeader;
    @NotNull
    private static final DerHeader END_OF_DATA = new DerHeader(0, 0L, false, -1L);

    public DerReader(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.countingSource = new CountingSource(source);
        this.source = Okio.buffer((Source)((Source)this.countingSource));
        this.limit = -1L;
        this.typeHintStack = new ArrayList();
        this.path = new ArrayList();
    }

    private final long getByteCount() {
        return this.countingSource.getBytesRead() - this.source.getBuffer().size();
    }

    @Nullable
    public final Object getTypeHint() {
        return CollectionsKt.lastOrNull(this.typeHintStack);
    }

    public final void setTypeHint(@Nullable Object value) {
        this.typeHintStack.set(this.typeHintStack.size() - 1, value);
    }

    private final long getBytesLeft() {
        return this.limit == -1L ? -1L : this.limit - this.getByteCount();
    }

    public final boolean hasNext() {
        return this.peekHeader() != null;
    }

    @Nullable
    public final DerHeader peekHeader() {
        DerHeader result = this.peekedHeader;
        if (result == null) {
            this.peekedHeader = result = this.readHeader$okhttp_tls();
        }
        if (result.isEndOfData()) {
            return null;
        }
        return result;
    }

    @NotNull
    public final DerHeader readHeader$okhttp_tls() {
        long l;
        if (!(this.peekedHeader == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getByteCount() == this.limit) {
            return END_OF_DATA;
        }
        if (this.limit == -1L && this.source.exhausted()) {
            return END_OF_DATA;
        }
        int tagAndClass = this.source.readByte() & 0xFF;
        int tagClass = tagAndClass & 0xC0;
        boolean constructed = (tagAndClass & 0x20) == 32;
        int tag0 = tagAndClass & 0x1F;
        long tag = tag0 == 31 ? this.readVariableLengthLong() : (long)tag0;
        int length0 = this.source.readByte() & 0xFF;
        if (length0 == 128) {
            throw new ProtocolException("indefinite length not permitted for DER");
        }
        if ((length0 & 0x80) == 128) {
            int lengthBytes = length0 & 0x7F;
            if (lengthBytes > 8) {
                throw new ProtocolException("length encoded with more than 8 bytes is not supported");
            }
            long lengthBits = (long)this.source.readByte() & 0xFFL;
            if (lengthBits == 0L || lengthBytes == 1 && (lengthBits & 0x80L) == 0L) {
                throw new ProtocolException("invalid encoding for length");
            }
            int n = 1;
            while (n < lengthBytes) {
                int i = n++;
                lengthBits <<= 8;
                lengthBits += (long)(this.source.readByte() & 0xFF);
            }
            if (lengthBits < 0L) {
                throw new ProtocolException("length > Long.MAX_VALUE");
            }
            l = lengthBits;
        } else {
            l = length0 & 0x7F;
        }
        long length = l;
        return new DerHeader(tagClass, tag, constructed, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T read$okhttp_tls(@Nullable String name, @NotNull Function1<? super DerHeader, ? extends T> block) {
        long newLimit;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$read$okhttp_tls = false;
        if (!this.hasNext()) {
            throw new ProtocolException("expected a value");
        }
        DerHeader derHeader = this.peekedHeader;
        Intrinsics.checkNotNull((Object)derHeader);
        DerHeader header = derHeader;
        this.peekedHeader = null;
        long pushedLimit = this.limit;
        boolean pushedConstructed = this.constructed;
        long l = newLimit = header.getLength() != -1L ? this.getByteCount() + header.getLength() : -1L;
        if (pushedLimit != -1L && newLimit > pushedLimit) {
            throw new ProtocolException("enclosed object too large");
        }
        this.limit = newLimit;
        this.constructed = header.getConstructed();
        if (name != null) {
            ((Collection)this.path).add(name);
        }
        try {
            Object result = block.invoke((Object)header);
            if (newLimit != -1L && this.getByteCount() > newLimit) {
                throw new ProtocolException(Intrinsics.stringPlus((String)"unexpected byte count at ", (Object)this));
            }
            Object object = result;
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.peekedHeader = null;
            this.limit = pushedLimit;
            this.constructed = pushedConstructed;
            if (name != null) {
                this.path.remove(this.path.size() - 1);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withTypeHint(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.typeHintStack.add(null);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.typeHintStack.remove(this.typeHintStack.size() - 1);
        }
    }

    public final boolean readBoolean() {
        if (this.getBytesLeft() != 1L) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        return this.source.readByte() != 0;
    }

    @NotNull
    public final BigInteger readBigInteger() {
        if (this.getBytesLeft() == 0L) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        byte[] byteArray = this.source.readByteArray(this.getBytesLeft());
        return new BigInteger(byteArray);
    }

    public final long readLong() {
        long l = this.getBytesLeft();
        if (!(1L <= l ? l < 9L : false)) {
            throw new ProtocolException("unexpected length: " + this.getBytesLeft() + " at " + this);
        }
        long result = this.source.readByte();
        while (this.getByteCount() < this.limit) {
            result <<= 8;
            result += (long)(this.source.readByte() & 0xFF);
        }
        return result;
    }

    @NotNull
    public final BitString readBitString() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed bit strings not supported for DER");
        }
        if (this.getBytesLeft() < 1L) {
            throw new ProtocolException("malformed bit string");
        }
        int unusedBitCount = this.source.readByte() & 0xFF;
        ByteString byteString = this.source.readByteString(this.getBytesLeft());
        return new BitString(byteString, unusedBitCount);
    }

    @NotNull
    public final ByteString readOctetString() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed octet strings not supported for DER");
        }
        return this.source.readByteString(this.getBytesLeft());
    }

    @NotNull
    public final String readUtf8String() {
        if (this.getBytesLeft() == -1L || this.constructed) {
            throw new ProtocolException("constructed strings not supported for DER");
        }
        return this.source.readUtf8(this.getBytesLeft());
    }

    @NotNull
    public final String readObjectIdentifier() {
        Buffer result = new Buffer();
        byte dot = (byte)46;
        long xy = this.readVariableLengthLong();
        boolean bl = 0L <= xy ? xy < 40L : false;
        if (bl) {
            result.writeDecimalLong(0L);
            result.writeByte((int)dot);
            result.writeDecimalLong(xy);
        } else {
            boolean bl2 = 40L <= xy ? xy < 80L : false;
            if (bl2) {
                result.writeDecimalLong(1L);
                result.writeByte((int)dot);
                result.writeDecimalLong(xy - 40L);
            } else {
                result.writeDecimalLong(2L);
                result.writeByte((int)dot);
                result.writeDecimalLong(xy - 80L);
            }
        }
        while (this.getByteCount() < this.limit) {
            result.writeByte((int)dot);
            result.writeDecimalLong(this.readVariableLengthLong());
        }
        return result.readUtf8();
    }

    @NotNull
    public final String readRelativeObjectIdentifier() {
        Buffer result = new Buffer();
        byte dot = (byte)46;
        while (this.getByteCount() < this.limit) {
            if (result.size() > 0L) {
                result.writeByte((int)dot);
            }
            result.writeDecimalLong(this.readVariableLengthLong());
        }
        return result.readUtf8();
    }

    private final long readVariableLengthLong() {
        long byteN;
        long result = 0L;
        while (((byteN = (long)this.source.readByte() & 0xFFL) & 0x80L) == 128L) {
            result = result + (byteN & 0x7FL) << 7;
        }
        return result + byteN;
    }

    @NotNull
    public final ByteString readUnknown() {
        return this.source.readByteString(this.getBytesLeft());
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.path, (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/tls/internal/der/DerReader$Companion;", "", "()V", "END_OF_DATA", "Lokhttp3/tls/internal/der/DerHeader;", "okhttp-tls"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lokhttp3/tls/internal/der/DerReader$CountingSource;", "Lokio/ForwardingSource;", "source", "Lokio/Source;", "(Lokio/Source;)V", "bytesRead", "", "getBytesRead", "()J", "setBytesRead", "(J)V", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp-tls"})
    private static final class CountingSource
    extends ForwardingSource {
        private long bytesRead;

        public CountingSource(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(source);
        }

        public final long getBytesRead() {
            return this.bytesRead;
        }

        public final void setBytesRead(long l) {
            this.bytesRead = l;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            long result = this.delegate().read(sink, byteCount);
            if (result == -1L) {
                return -1L;
            }
            this.bytesRead += result;
            return result;
        }
    }
}

