//[okhttp-dnsoverhttps](../../../index.md)/[okhttp3.dnsoverhttps](../index.md)/[DnsOverHttps](index.md)

# DnsOverHttps

[jvm]\
class [DnsOverHttps](index.md) : Dns

[DNS over HTTPS implementation](https://tools.ietf.org/html/draft-ietf-doh-dns-over-https-13).

A DNS API client encodes a single DNS query into an HTTP request using either the HTTP GET or POST method and the other requirements of this section.  The DNS API server defines the URI used by the request through the use of a URI Template.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [lookup](lookup.md) | [jvm]<br>open override fun [lookup](lookup.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[InetAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetAddress.html)&gt; |

## Properties

| Name | Summary |
|---|---|
| [client](client.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;client&quot;)<br>val [client](client.md): OkHttpClient |
| [includeIPv6](include-i-pv6.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;includeIPv6&quot;)<br>val [includeIPv6](include-i-pv6.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [post](post.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;post&quot;)<br>val [post](post.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [resolvePrivateAddresses](resolve-private-addresses.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;resolvePrivateAddresses&quot;)<br>val [resolvePrivateAddresses](resolve-private-addresses.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [resolvePublicAddresses](resolve-public-addresses.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;resolvePublicAddresses&quot;)<br>val [resolvePublicAddresses](resolve-public-addresses.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [url](url.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;url&quot;)<br>val [url](url.md): HttpUrl |
