//[okhttp-tls](../../../../index.md)/[okhttp3.tls](../../index.md)/[HandshakeCertificates](../index.md)/[Builder](index.md)/[addInsecureHost](add-insecure-host.md)

# addInsecureHost

[jvm]\
fun [addInsecureHost](add-insecure-host.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HandshakeCertificates.Builder](index.md)

Configures this to not authenticate the HTTPS server on to [hostname](add-insecure-host.md). This makes the user vulnerable to man-in-the-middle attacks and should only be used only in private development environments and only to carry test data.

The server’s TLS certificate **does not need to be signed** by a trusted certificate authority. Instead, it will trust any well-formed certificate, even if it is self-signed. This is necessary for testing against localhost or in development environments where a certificate authority is not possible.

The server’s TLS certificate still must match the requested hostname. For example, if the certificate is issued to example.com and the request is to localhost, the connection will fail. Use a custom [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html) to ignore such problems.

Other TLS features are still used but provide no security benefits in absence of the above gaps. For example, an insecure TLS connection is capable of negotiating HTTP/2 with ALPN and it also has a regular-looking handshake.

**This feature is not supported on Android API levels less than 24.** Prior releases lacked a mechanism to trust some hosts and not others.

## Parameters

jvm

| | |
|---|---|
| hostname | the exact hostname from the URL for insecure connections. |
