//[okhttp-tls](../../../../index.md)/[okhttp3.tls](../../index.md)/[HeldCertificate](../index.md)/[Builder](index.md)

# Builder

[jvm]\
class [Builder](index.md)

Build a held certificate with reasonable defaults.

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [addSubjectAlternativeName](add-subject-alternative-name.md) | [jvm]<br>fun [addSubjectAlternativeName](add-subject-alternative-name.md)(altName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HeldCertificate.Builder](index.md)<br>Adds a subject alternative name (SAN) to the certificate. This is usually a literal hostname, a literal IP address, or a hostname pattern. If no subject alternative names are added that extension will be omitted. |
| [build](build.md) | [jvm]<br>fun [build](build.md)(): [HeldCertificate](../index.md) |
| [certificateAuthority](certificate-authority.md) | [jvm]<br>fun [certificateAuthority](certificate-authority.md)(maxIntermediateCas: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [HeldCertificate.Builder](index.md)<br>Set this certificate to be a signing certificate, with up to maxIntermediateCas intermediate signing certificates beneath it. |
| [commonName](common-name.md) | [jvm]<br>fun [commonName](common-name.md)(cn: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HeldCertificate.Builder](index.md)<br>Set this certificate's common name (CN). Historically this held the hostname of TLS certificate, but that practice was deprecated by [RFC 2818](https://tools.ietf.org/html/rfc2818) and replaced with [addSubjectAlternativeName](add-subject-alternative-name.md). If unset a random string will be used. |
| [duration](duration.md) | [jvm]<br>fun [duration](duration.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [HeldCertificate.Builder](index.md)<br>Sets the certificate to be valid immediately and until the specified duration has elapsed. The precision of this field is seconds; further precision will be truncated. |
| [ecdsa256](ecdsa256.md) | [jvm]<br>fun [ecdsa256](ecdsa256.md)(): [HeldCertificate.Builder](index.md)<br>Configure the certificate to generate a 256-bit ECDSA key, which provides about 128 bits of security. ECDSA keys are noticeably faster than RSA keys. |
| [keyPair](key-pair.md) | [jvm]<br>fun [keyPair](key-pair.md)(keyPair: [KeyPair](https://docs.oracle.com/javase/8/docs/api/java/security/KeyPair.html)): [HeldCertificate.Builder](index.md)<br>fun [keyPair](key-pair.md)(publicKey: [PublicKey](https://docs.oracle.com/javase/8/docs/api/java/security/PublicKey.html), privateKey: [PrivateKey](https://docs.oracle.com/javase/8/docs/api/java/security/PrivateKey.html)): [HeldCertificate.Builder](index.md)<br>Sets the public/private key pair used for this certificate. If unset a key pair will be generated. |
| [organizationalUnit](organizational-unit.md) | [jvm]<br>fun [organizationalUnit](organizational-unit.md)(ou: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HeldCertificate.Builder](index.md)<br>Sets the certificate's organizational unit (OU). If unset this field will be omitted. |
| [rsa2048](rsa2048.md) | [jvm]<br>fun [rsa2048](rsa2048.md)(): [HeldCertificate.Builder](index.md)<br>Configure the certificate to generate a 2048-bit RSA key, which provides about 112 bits of security. RSA keys are interoperable with very old clients that don't support ECDSA. |
| [serialNumber](serial-number.md) | [jvm]<br>fun [serialNumber](serial-number.md)(serialNumber: [BigInteger](https://docs.oracle.com/javase/8/docs/api/java/math/BigInteger.html)): [HeldCertificate.Builder](index.md)<br>fun [serialNumber](serial-number.md)(serialNumber: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [HeldCertificate.Builder](index.md)<br>Sets this certificate's serial number. If unset the serial number will be 1. |
| [signedBy](signed-by.md) | [jvm]<br>fun [signedBy](signed-by.md)(signedBy: [HeldCertificate](../index.md)?): [HeldCertificate.Builder](index.md)<br>Set the certificate that will issue this certificate. If unset the certificate will be self-signed. |
| [validityInterval](validity-interval.md) | [jvm]<br>fun [validityInterval](validity-interval.md)(notBefore: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), notAfter: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [HeldCertificate.Builder](index.md)<br>Sets the certificate to be valid in ``[notBefore..notAfter]``. Both endpoints are specified in the format of [System.currentTimeMillis](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#currentTimeMillis--). Specify -1L for both values to use the default interval, 24 hours starting when the certificate is created. |
