//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[CacheControl](../index.md)/[Builder](index.md)/[maxStale](max-stale.md)

# maxStale

[jvm]\
fun [maxStale](max-stale.md)(maxStale: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [CacheControl.Builder](index.md)

Accept cached responses that have exceeded their freshness lifetime by up to maxStale. If unspecified, stale cache responses will not be used.

## Parameters

jvm

| | |
|---|---|
| maxStale | a non-negative integer. This is stored and transmitted with     [TimeUnit.SECONDS](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html#SECONDS) precision; finer precision will be lost. |

[common]\
expect fun [maxStale](max-stale.md)(maxStale: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)

Accept cached responses that have exceeded their freshness lifetime by up to maxStale. If unspecified, stale cache responses will not be used.

## Parameters

common

| | |
|---|---|
| maxStale | a non-negative integer. This is stored and transmitted with     TimeUnit.SECONDS precision; finer precision will be lost. |

[jvm]\
actual fun [maxStale](max-stale.md)(maxStale: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)
