//[okhttp](../../../index.md)/[okhttp3](../index.md)/[ConnectionSpec](index.md)

# ConnectionSpec

[jvm]\
class [ConnectionSpec](index.md)

Specifies configuration for the socket connection that HTTP traffic travels through. For https: URLs, this includes the TLS version and cipher suites to use when negotiating a secure connection.

The TLS versions configured in a connection spec are only be used if they are also enabled in the SSL socket. For example, if an SSL socket does not have TLS 1.3 enabled, it will not be used even if it is present on the connection spec. The same policy also applies to cipher suites.

Use [Builder.allEnabledTlsVersions](-builder/all-enabled-tls-versions.md) and [Builder.allEnabledCipherSuites](-builder/all-enabled-cipher-suites.md) to defer all feature selection to the underlying SSL socket.

The configuration of each spec changes with each OkHttp release. This is annoying: upgrading your OkHttp library can break connectivity to certain web servers! But it’s a necessary annoyance because the TLS ecosystem is dynamic and staying up to date is necessary to stay secure. See [OkHttp's TLS Configuration History](https://square.github.io/okhttp/tls_configuration_history/) to track these changes.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [isCompatible](is-compatible.md) | [jvm]<br>fun [isCompatible](is-compatible.md)(socket: [SSLSocket](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocket.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the socket, as currently configured, supports this connection spec. In order for a socket to be compatible the enabled cipher suites and protocols must intersect. |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [cipherSuites](cipher-suites.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;cipherSuites&quot;)<br>val [cipherSuites](cipher-suites.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[CipherSuite](../-cipher-suite/index.md)&gt;?<br>Returns the cipher suites to use for a connection. Returns null if all of the SSL socket's enabled cipher suites should be used. |
| [isTls](is-tls.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;isTls&quot;)<br>val [isTls](is-tls.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [supportsTlsExtensions](supports-tls-extensions.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;supportsTlsExtensions&quot;)<br>val [supportsTlsExtensions](supports-tls-extensions.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [tlsVersions](tls-versions.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;tlsVersions&quot;)<br>val [tlsVersions](tls-versions.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TlsVersion](../-tls-version/index.md)&gt;?<br>Returns the TLS versions to use when negotiating a connection. Returns null if all of the SSL socket's enabled TLS versions should be used. |
