//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[queryParameterValue](query-parameter-value.md)

# queryParameterValue

[jvm]\
fun [queryParameterValue](query-parameter-value.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?

Returns the value of the query parameter at index. For example this returns &quot;apple&quot; for queryParameterName(0) on http://host/?a=apple&amp;b=banana. This throws if index is not less than the [query size](query-size.md).

| URL | queryParameterValue(0) | queryParameterValue(1) |
|---|---|---|
| http://host/ | exception | exception |
| http://host/? | null | exception |
| http://host/?a=apple&amp;k=key+lime | &quot;apple&quot; | &quot;key lime&quot; |
| http://host/?a=apple&amp;a=apricot | &quot;apple&quot; | &quot;apricot&quot; |
| http://host/?a=apple&amp;b | &quot;apple&quot; | null |
