//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Interceptor](index.md)

# Interceptor

[jvm]\
fun interface [Interceptor](index.md)

Observes, modifies, and potentially short-circuits requests going out and the corresponding responses coming back in. Typically interceptors add, remove, or transform headers on the request or response.

Implementations of this interface throw [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html) to signal connectivity failures. This includes both natural exceptions such as unreachable servers, as well as synthetic exceptions when responses are of an unexpected type or cannot be decoded.

Other exception types cancel the current call:

- 
   For synchronous calls made with [Call.execute](../-call/execute.md), the exception is propagated to the caller.
- 
   For asynchronous calls made with [Call.enqueue](../-call/enqueue.md), an [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html) is propagated to the caller     indicating that the call was canceled. The interceptor's exception is delivered to the current     thread's [uncaught exception handler](https://docs.oracle.com/javase/8/docs/api/java/lang/Thread.UncaughtExceptionHandler.html). By default this     crashes the application on Android and prints a stacktrace on the JVM. (Crash reporting     libraries may customize this behavior.)

A good way to signal a failure is with a synthetic HTTP response:

@Throws(IOException::class)\
override fun intercept(chain: Interceptor.Chain): Response {\
  if (myConfig.isInvalid()) {\
    return Response.Builder()\
        .request(chain.request())\
        .protocol(Protocol.HTTP_1_1)\
        .code(400)\
        .message(&quot;client config invalid&quot;)\
        .body(&quot;client config invalid&quot;.toResponseBody(null))\
        .build()\
  }\
\
  return chain.proceed(chain.request())\
}

## Types

| Name | Summary |
|---|---|
| [Chain](-chain/index.md) | [jvm]<br>interface [Chain](-chain/index.md) |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [intercept](intercept.md) | [jvm]<br>abstract fun [intercept](intercept.md)(chain: [Interceptor.Chain](-chain/index.md)): [Response](../-response/index.md) |
