//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[MockWebServer](index.md)

# MockWebServer

[jvm]\
class [MockWebServer](index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)

A scriptable web server. Callers supply canned responses and the server replays them upon request in sequence.

## Constructors

| | |
|---|---|
| [MockWebServer](-mock-web-server.md) | [jvm]<br>fun [MockWebServer](-mock-web-server.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [enqueue](enqueue.md) | [jvm]<br>fun [enqueue](enqueue.md)(response: [MockResponse](../-mock-response/index.md))<br>Scripts [response](enqueue.md) to be returned to a request made in sequence. The first request is served by the first enqueued response; the second request by the second enqueued response; and so on. |
| [noClientAuth](no-client-auth.md) | [jvm]<br>fun [noClientAuth](no-client-auth.md)()<br>Configure the server to not perform SSL authentication of the client. This leaves authentication to another layer such as in an HTTP cookie or header. This is the default and most common configuration. |
| [requestClientAuth](request-client-auth.md) | [jvm]<br>fun [requestClientAuth](request-client-auth.md)()<br>Configure the server to [want client auth](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocket.html#setWantClientAuth-kotlin.Boolean-). If the client presents a certificate that is [trusted](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/TrustManager.html) the handshake will proceed normally. The connection will also proceed normally if the client presents no certificate at all! But if the client presents an untrusted certificate the handshake will fail and no connection will be established. |
| [requireClientAuth](require-client-auth.md) | [jvm]<br>fun [requireClientAuth](require-client-auth.md)()<br>Configure the server to [need client auth](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocket.html#setNeedClientAuth-kotlin.Boolean-). If the client presents a certificate that is [trusted](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/TrustManager.html) the handshake will proceed normally. If the client presents an untrusted certificate or no certificate at all the handshake will fail and no connection will be established. |
| [shutdown](shutdown.md) | [jvm]<br>@[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>fun [shutdown](shutdown.md)() |
| [start](start.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [start](start.md)(port: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0)<br>Starts the server on the loopback interface for the given port.<br>[jvm]<br>fun [start](start.md)(inetAddress: [InetAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetAddress.html), port: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Starts the server on the given address and port. |
| [takeRequest](take-request.md) | [jvm]<br>fun [takeRequest](take-request.md)(): [RecordedRequest](../-recorded-request/index.md)<br>Awaits the next HTTP request, removes it, and returns it. Callers should use this to verify the request was sent as intended. This method will block until the request is available, possibly forever.<br>[jvm]<br>fun [takeRequest](take-request.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [RecordedRequest](../-recorded-request/index.md)?<br>Awaits the next HTTP request (waiting up to the specified wait time if necessary), removes it, and returns it. Callers should use this to verify the request was sent as intended within the given time. |
| [toProxyAddress](to-proxy-address.md) | [jvm]<br>fun [toProxyAddress](to-proxy-address.md)(): [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [url](url.md) | [jvm]<br>fun [url](url.md)(path: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): HttpUrl<br>Returns a URL for connecting to this server. |
| [useHttps](use-https.md) | [jvm]<br>fun [useHttps](use-https.md)(sslSocketFactory: [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html))<br>Serve requests with HTTPS rather than otherwise. |

## Properties

| Name | Summary |
|---|---|
| [bodyLimit](body-limit.md) | [jvm]<br>var [bodyLimit](body-limit.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>The number of bytes of the POST body to keep in memory to the given limit. |
| [dispatcher](dispatcher.md) | [jvm]<br>var [dispatcher](dispatcher.md): [Dispatcher](../-dispatcher/index.md)<br>The dispatcher used to respond to HTTP requests. The default dispatcher is a [QueueDispatcher](../-queue-dispatcher/index.md), which serves a fixed sequence of responses from a [queue](enqueue.md). |
| [hostName](host-name.md) | [jvm]<br>val [hostName](host-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [inetSocketAddress](inet-socket-address.md) | [jvm]<br>val [inetSocketAddress](inet-socket-address.md): [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html) |
| [port](port.md) | [jvm]<br>val [port](port.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [protocolNegotiationEnabled](protocol-negotiation-enabled.md) | [jvm]<br>var [protocolNegotiationEnabled](protocol-negotiation-enabled.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true<br>True if ALPN is used on incoming HTTPS connections to negotiate a protocol like HTTP/1.1 or HTTP/2. This is true by default; set to false to disable negotiation and restrict connections to HTTP/1.1. |
| [protocols](protocols.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;protocols&quot;)<br>var [protocols](protocols.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;<br>The protocols supported by ALPN on incoming HTTPS connections in order of preference. The list must contain Protocol.HTTP_1_1. It must not contain null. |
| [requestCount](request-count.md) | [jvm]<br>val [requestCount](request-count.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The number of HTTP requests received thus far by this server. This may exceed the number of HTTP connections when connection reuse is in practice. |
| [serverSocketFactory](server-socket-factory.md) | [jvm]<br>@get:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>@set:[Synchronized](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-synchronized/index.html)<br>var [serverSocketFactory](server-socket-factory.md): [ServerSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ServerSocketFactory.html)? = null |
| [started](started.md) | [jvm]<br>var [started](started.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false |
