//[okhttp-tls](../../../../index.md)/[okhttp3.tls](../../index.md)/[HandshakeCertificates](../index.md)/[Builder](index.md)

# Builder

[jvm]\
class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [addInsecureHost](add-insecure-host.md) | [jvm]<br>fun [addInsecureHost](add-insecure-host.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HandshakeCertificates.Builder](index.md)<br>Configures this to not authenticate the HTTPS server on to [hostname](add-insecure-host.md). This makes the user vulnerable to man-in-the-middle attacks and should only be used only in private development environments and only to carry test data. |
| [addPlatformTrustedCertificates](add-platform-trusted-certificates.md) | [jvm]<br>fun [addPlatformTrustedCertificates](add-platform-trusted-certificates.md)(): [HandshakeCertificates.Builder](index.md)<br>Add all of the host platform's trusted root certificates. This set varies by platform (Android vs. Java), by platform release (Android 4.4 vs. Android 9), and with user customizations. |
| [addTrustedCertificate](add-trusted-certificate.md) | [jvm]<br>fun [addTrustedCertificate](add-trusted-certificate.md)(certificate: [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html)): [HandshakeCertificates.Builder](index.md)<br>Add a trusted root certificate to use when authenticating a peer. Peers must provide a chain of certificates whose root is one of these. |
| [build](build.md) | [jvm]<br>fun [build](build.md)(): [HandshakeCertificates](../index.md) |
| [heldCertificate](held-certificate.md) | [jvm]<br>fun [heldCertificate](held-certificate.md)(heldCertificate: [HeldCertificate](../../-held-certificate/index.md), vararg intermediates: [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html)): [HandshakeCertificates.Builder](index.md)<br>Configure the certificate chain to use when being authenticated. The first certificate is the held certificate, further certificates are included in the handshake so the peer can build a trusted path to a trusted root certificate. |
