//[okhttp-tls](../../../index.md)/[okhttp3.tls](../index.md)/[HeldCertificate](index.md)

# HeldCertificate

[jvm]\
class [HeldCertificate](index.md)(val keyPair: [KeyPair](https://docs.oracle.com/javase/8/docs/api/java/security/KeyPair.html), val certificate: [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html))

A certificate and its private key. These are some properties of certificates that are used with TLS:

- 
   **A common name.** This is a string identifier for the certificate. It usually describes the     purpose of the certificate like &quot;Entrust Root Certification Authority - G2&quot; or     &quot;www.squareup.com&quot;.
- 
   **A set of hostnames.** These are in the certificate's subject alternative name (SAN)     extension. A subject alternative name is either a literal hostname (`squareup.com`), a literal     IP address (`74.122.190.80`), or a hostname pattern (`*.api.squareup.com`).
- 
   **A validity interval.** A certificate should not be used before its validity interval starts     or after it ends.
- 
   **A public key.** This cryptographic key is used for asymmetric encryption digital signatures.     Note that the private key is not a part of the certificate!
- 
   **A signature issued by another certificate's private key.** This mechanism allows a trusted     third-party to endorse a certificate. Third parties should only endorse certificates once     they've confirmed that the owner of the private key is also the owner of the certificate's     other properties.

Certificates are signed by other certificates and a sequence of them is called a certificate chain. The chain terminates in a self-signed &quot;root&quot; certificate. Signing certificates in the middle of the chain are called &quot;intermediates&quot;. Organizations that offer certificate signing are called certificate authorities (CAs).

Browsers and other HTTP clients need a set of trusted root certificates to authenticate their peers. Sets of root certificates are managed by either the HTTP client (like Firefox), or the host platform (like Android). In July 2018 Android had 134 trusted root certificates for its HTTP clients to trust.

For example, in order to establish a secure connection to `https://www.squareup.com/`, these three certificates are used.

```kotlin
www.squareup.com certificate:

Common Name: www.squareup.com
Subject Alternative Names: www.squareup.com, squareup.com, account.squareup.com...
Validity: 2018-07-03T20:18:17Z – 2019-08-01T20:48:15Z
Public Key: d107beecc17325f55da976bcbab207ba4df68bd3f8fce7c3b5850311128264fd53e1baa342f58d93...
Signature: 1fb0e66fac05322721fe3a3917f7c98dee1729af39c99eab415f22d8347b508acdf0bab91781c3720...

signed by intermediate certificate:

Common Name: Entrust Certification Authority - L1M
Subject Alternative Names: none
Validity: 2014-12-15T15:25:03Z – 2030-10-15T15:55:03Z
Public Key: d081c13923c2b1d1ecf757dd55243691202248f7fcca520ab0ab3f33b5b08407f6df4e7ab0fb9822...
Signature: b487c784221a29c0a478ecf54f1bb484976f77eed4cf59afa843962f1d58dea6f3155b2ed9439c4c4...

signed by root certificate:

Common Name: Entrust Root Certification Authority - G2
Subject Alternative Names: none
Validity: 2009-07-07T17:25:54Z – 2030-12-07T17:55:54Z
Public Key: ba84b672db9e0c6be299e93001a776ea32b895411ac9da614e5872cffef68279bf7361060aa527d8...
Self-signed Signature: 799f1d96c6b6793f228d87d3870304606a6b9a2e59897311ac43d1f513ff8d392bc0f...
```

In this example the HTTP client already knows and trusts the last certificate, &quot;Entrust Root Certification Authority - G2&quot;. That certificate is used to verify the signature of the intermediate certificate, &quot;Entrust Certification Authority - L1M&quot;. The intermediate certificate is used to verify the signature of the &quot;www.squareup.com&quot; certificate.

This roles are reversed for client authentication. In that case the client has a private key and a chain of certificates. The server uses a set of trusted root certificates to authenticate the client. Subject alternative names are not used for client authentication.

## Constructors

| | |
|---|---|
| [HeldCertificate](-held-certificate.md) | [jvm]<br>fun [HeldCertificate](-held-certificate.md)(keyPair: [KeyPair](https://docs.oracle.com/javase/8/docs/api/java/security/KeyPair.html), certificate: [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html)) |

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md)<br>Build a held certificate with reasonable defaults. |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [certificatePem](certificate-pem.md) | [jvm]<br>fun [certificatePem](certificate-pem.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the certificate encoded in [PEM format](https://tools.ietf.org/html/rfc7468). |
| [privateKeyPkcs1Pem](private-key-pkcs1-pem.md) | [jvm]<br>fun [privateKeyPkcs1Pem](private-key-pkcs1-pem.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the RSA private key encoded in [PKCS #1](https://tools.ietf.org/html/rfc8017)[PEM format](https://tools.ietf.org/html/rfc7468). |
| [privateKeyPkcs8Pem](private-key-pkcs8-pem.md) | [jvm]<br>fun [privateKeyPkcs8Pem](private-key-pkcs8-pem.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the private key encoded in [PKCS #8](https://tools.ietf.org/html/rfc5208)[PEM format](https://tools.ietf.org/html/rfc7468). |

## Properties

| Name | Summary |
|---|---|
| [certificate](certificate.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;certificate&quot;)<br>val [certificate](certificate.md): [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html) |
| [keyPair](key-pair.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;keyPair&quot;)<br>val [keyPair](key-pair.md): [KeyPair](https://docs.oracle.com/javase/8/docs/api/java/security/KeyPair.html) |
