//[okhttp-tls](../../index.md)/[okhttp3.tls](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [HandshakeCertificates](-handshake-certificates/index.md) | [jvm]<br>class [HandshakeCertificates](-handshake-certificates/index.md)<br>Certificates to identify which peers to trust and also to earn the trust of those peers in kind. Client and server exchange these certificates during the handshake phase of a TLS connection. |
| [HeldCertificate](-held-certificate/index.md) | [jvm]<br>class [HeldCertificate](-held-certificate/index.md)(val keyPair: [KeyPair](https://docs.oracle.com/javase/8/docs/api/java/security/KeyPair.html), val certificate: [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html))<br>A certificate and its private key. These are some properties of certificates that are used with TLS: |

## Functions

| Name | Summary |
|---|---|
| [certificatePem](certificate-pem.md) | [jvm]<br>fun [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html).[certificatePem](certificate-pem.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the certificate encoded in [PEM format](https://tools.ietf.org/html/rfc7468). |
| [decodeCertificatePem](decode-certificate-pem.md) | [jvm]<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[decodeCertificatePem](decode-certificate-pem.md)(): [X509Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/X509Certificate.html)<br>Decodes a multiline string that contains a [certificate](certificate-pem.md) which is rfc_7468. A typical input string looks like this: |
