//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[CacheControl](../index.md)/[Builder](index.md)/[minFresh](min-fresh.md)

# minFresh

[jvm]\
fun [minFresh](min-fresh.md)(minFresh: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [CacheControl.Builder](index.md)

Sets the minimum number of seconds that a response will continue to be fresh for. If the response will be stale when [minFresh](min-fresh.md) have elapsed, the cached response will not be used and a network request will be made.

#### Parameters

jvm

| | |
|---|---|
| minFresh | a non-negative integer. This is stored and transmitted with     [TimeUnit.SECONDS](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html#SECONDS) precision; finer precision will be lost. |

[common]\
expect fun [minFresh](min-fresh.md)(minFresh: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)

Sets the minimum number of seconds that a response will continue to be fresh for. If the response will be stale when [minFresh](min-fresh.md) have elapsed, the cached response will not be used and a network request will be made.

#### Parameters

common

| | |
|---|---|
| minFresh | a non-negative integer. This is stored and transmitted with     TimeUnit.SECONDS precision; finer precision will be lost. |

[jvm]\
actual fun [minFresh](min-fresh.md)(minFresh: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), timeUnit: [DurationUnit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.time/-duration-unit/index.html)): [CacheControl.Builder](index.md)
