//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Dns](index.md)

# Dns

[jvm]\
fun interface [Dns](index.md)

A domain name service that resolves IP addresses for host names. Most applications will use the [system DNS service](-companion/-s-y-s-t-e-m.md), which is the default. Some applications may provide their own implementation to use a different DNS server, to prefer IPv6 addresses, to prefer IPv4 addresses, or to force a specific known IP address.

Implementations of this interface must be safe for concurrent use.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [lookup](lookup.md) | [jvm]<br>abstract fun [lookup](lookup.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[InetAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetAddress.html)&gt;<br>Returns the IP addresses of `hostname`, in the order they will be attempted by OkHttp. If a connection to an address fails, OkHttp will retry the connection with the next address until either a connection is made, the set of IP addresses is exhausted, or a limit is exceeded. |
