//[okhttp](../../../index.md)/[okhttp3](../index.md)/[HttpUrl](index.md)/[query](query.md)

# query

[jvm]\

@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;query&quot;)

val [query](query.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?

This URL's query, like `"abc"` for `http://host/?abc`. Most callers should prefer [queryParameterName](query-parameter-name.md) and [queryParameterValue](query-parameter-value.md) because these methods offer direct access to individual query parameters.

| URL | `query()` |
|---|---|
| `http://host/` | null |
| `http://host/?` | `""` |
| `http://host/?a=apple&k=key+lime` | `"a=apple&k=key lime"` |
| `http://host/?a=apple&a=apricot` | `"a=apple&a=apricot"` |
| `http://host/?a=apple&b` | `"a=apple&b"` |
