//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)

# Builder

[jvm]\
class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Functions

| Name | Summary |
|---|---|
| [addInterceptor](add-interceptor.md) | [jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-addInterceptor&quot;)<br>inline fun [addInterceptor](add-interceptor.md)(crossinline block: (chain: [Interceptor.Chain](../../-interceptor/-chain/index.md)) -&gt; [Response](../../-response/index.md)): [OkHttpClient.Builder](index.md)<br>fun [addInterceptor](add-interceptor.md)(interceptor: [Interceptor](../../-interceptor/index.md)): [OkHttpClient.Builder](index.md) |
| [addNetworkInterceptor](add-network-interceptor.md) | [jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-addNetworkInterceptor&quot;)<br>inline fun [addNetworkInterceptor](add-network-interceptor.md)(crossinline block: (chain: [Interceptor.Chain](../../-interceptor/-chain/index.md)) -&gt; [Response](../../-response/index.md)): [OkHttpClient.Builder](index.md)<br>fun [addNetworkInterceptor](add-network-interceptor.md)(interceptor: [Interceptor](../../-interceptor/index.md)): [OkHttpClient.Builder](index.md) |
| [authenticator](authenticator.md) | [jvm]<br>fun [authenticator](authenticator.md)(authenticator: [Authenticator](../../-authenticator/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the authenticator used to respond to challenges from origin servers. Use [proxyAuthenticator](proxy-authenticator.md) to set the authenticator for proxy servers. |
| [build](build.md) | [jvm]<br>fun [build](build.md)(): [OkHttpClient](../index.md) |
| [cache](cache.md) | [jvm]<br>fun [cache](cache.md)(cache: [Cache](../../-cache/index.md)?): [OkHttpClient.Builder](index.md)<br>Sets the response cache to be used to read and write cached responses. |
| [callTimeout](call-timeout.md) | [jvm]<br>@IgnoreJRERequirement<br>fun [callTimeout](call-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)<br>fun [callTimeout](call-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)<br>Sets the default timeout for complete calls. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds. |
| [certificatePinner](certificate-pinner.md) | [jvm]<br>fun [certificatePinner](certificate-pinner.md)(certificatePinner: [CertificatePinner](../../-certificate-pinner/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the certificate pinner that constrains which certificates are trusted. By default HTTPS connections rely on only the SSL socket factory to establish trust. Pinning certificates avoids the need to trust certificate authorities. |
| [connectionPool](connection-pool.md) | [jvm]<br>fun [connectionPool](connection-pool.md)(connectionPool: [ConnectionPool](../../-connection-pool/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the connection pool used to recycle HTTP and HTTPS connections. |
| [connectionSpecs](connection-specs.md) | [jvm]<br>fun [connectionSpecs](connection-specs.md)(connectionSpecs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ConnectionSpec](../../-connection-spec/index.md)&gt;): [OkHttpClient.Builder](index.md) |
| [connectTimeout](connect-timeout.md) | [jvm]<br>@IgnoreJRERequirement<br>fun [connectTimeout](connect-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)<br>fun [connectTimeout](connect-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)<br>Sets the default connect timeout for new connections. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds. |
| [cookieJar](cookie-jar.md) | [jvm]<br>fun [cookieJar](cookie-jar.md)(cookieJar: [CookieJar](../../-cookie-jar/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the handler that can accept cookies from incoming HTTP responses and provides cookies to outgoing HTTP requests. |
| [dispatcher](dispatcher.md) | [jvm]<br>fun [dispatcher](dispatcher.md)(dispatcher: [Dispatcher](../../-dispatcher/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the dispatcher used to set policy and execute asynchronous requests. Must not be null. |
| [dns](dns.md) | [jvm]<br>fun [dns](dns.md)(dns: [Dns](../../-dns/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the DNS service used to lookup IP addresses for hostnames. |
| [eventListener](event-listener.md) | [jvm]<br>fun [eventListener](event-listener.md)(eventListener: [EventListener](../../-event-listener/index.md)): [OkHttpClient.Builder](index.md)<br>Configure a single client scoped listener that will receive all analytic events for this client. |
| [eventListenerFactory](event-listener-factory.md) | [jvm]<br>fun [eventListenerFactory](event-listener-factory.md)(eventListenerFactory: [EventListener.Factory](../../-event-listener/-factory/index.md)): [OkHttpClient.Builder](index.md)<br>Configure a factory to provide per-call scoped listeners that will receive analytic events for this client. |
| [fastFallback](fast-fallback.md) | [jvm]<br>fun [fastFallback](fast-fallback.md)(fastFallback: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [OkHttpClient.Builder](index.md)<br>Configure this client to perform fast fallbacks by attempting multiple connections concurrently, returning once any connection connects successfully. |
| [followRedirects](follow-redirects.md) | [jvm]<br>fun [followRedirects](follow-redirects.md)(followRedirects: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [OkHttpClient.Builder](index.md)<br>Configure this client to follow redirects. If unset, redirects will be followed. |
| [followSslRedirects](follow-ssl-redirects.md) | [jvm]<br>fun [followSslRedirects](follow-ssl-redirects.md)(followProtocolRedirects: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [OkHttpClient.Builder](index.md)<br>Configure this client to allow protocol redirects from HTTPS to HTTP and from HTTP to HTTPS. Redirects are still first restricted by [followRedirects](follow-redirects.md).  Defaults to true. |
| [hostnameVerifier](hostname-verifier.md) | [jvm]<br>fun [hostnameVerifier](hostname-verifier.md)(hostnameVerifier: [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html)): [OkHttpClient.Builder](index.md)<br>Sets the verifier used to confirm that response certificates apply to requested hostnames for HTTPS connections. |
| [interceptors](interceptors.md) | [jvm]<br>fun [interceptors](interceptors.md)(): [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[Interceptor](../../-interceptor/index.md)&gt;<br>Returns a modifiable list of interceptors that observe the full span of each call: from before the connection is established (if any) until after the response source is selected (either the origin server, cache, or both). |
| [minWebSocketMessageToCompress](min-web-socket-message-to-compress.md) | [jvm]<br>fun [minWebSocketMessageToCompress](min-web-socket-message-to-compress.md)(bytes: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [OkHttpClient.Builder](index.md)<br>Sets minimum outbound web socket message size (in bytes) that will be compressed. |
| [networkInterceptors](network-interceptors.md) | [jvm]<br>fun [networkInterceptors](network-interceptors.md)(): [MutableList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-list/index.html)&lt;[Interceptor](../../-interceptor/index.md)&gt;<br>Returns a modifiable list of interceptors that observe a single network request and response. These interceptors must call [Interceptor.Chain.proceed](../../-interceptor/-chain/proceed.md) exactly once: it is an error for a network interceptor to short-circuit or repeat a network request. |
| [pingInterval](ping-interval.md) | [jvm]<br>@IgnoreJRERequirement<br>fun [pingInterval](ping-interval.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)<br>fun [pingInterval](ping-interval.md)(interval: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)<br>Sets the interval between HTTP/2 and web socket pings initiated by this client. Use this to automatically send ping frames until either the connection fails or it is closed. This keeps the connection alive and may detect connectivity failures. |
| [protocols](protocols.md) | [jvm]<br>fun [protocols](protocols.md)(protocols: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;): [OkHttpClient.Builder](index.md)<br>Configure the protocols used by this client to communicate with remote servers. By default this client will prefer the most efficient transport available, falling back to more ubiquitous protocols. Applications should only call this method to avoid specific compatibility problems, such as web servers that behave incorrectly when HTTP/2 is enabled. |
| [proxy](proxy.md) | [jvm]<br>fun [proxy](proxy.md)(proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)?): [OkHttpClient.Builder](index.md)<br>Sets the HTTP proxy that will be used by connections created by this client. This takes precedence over [proxySelector](proxy-selector.md), which is only honored when this proxy is null (which it is by default). To disable proxy use completely, call `proxy(Proxy.NO_PROXY)`. |
| [proxyAuthenticator](proxy-authenticator.md) | [jvm]<br>fun [proxyAuthenticator](proxy-authenticator.md)(proxyAuthenticator: [Authenticator](../../-authenticator/index.md)): [OkHttpClient.Builder](index.md)<br>Sets the authenticator used to respond to challenges from proxy servers. Use [authenticator](authenticator.md) to set the authenticator for origin servers. |
| [proxySelector](proxy-selector.md) | [jvm]<br>fun [proxySelector](proxy-selector.md)(proxySelector: [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html)): [OkHttpClient.Builder](index.md)<br>Sets the proxy selection policy to be used if no [proxy](proxy.md) is specified explicitly. The proxy selector may return multiple proxies; in that case they will be tried in sequence until a successful connection is established. |
| [readTimeout](read-timeout.md) | [jvm]<br>@IgnoreJRERequirement<br>fun [readTimeout](read-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)<br>fun [readTimeout](read-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)<br>Sets the default read timeout for new connections. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds. |
| [retryOnConnectionFailure](retry-on-connection-failure.md) | [jvm]<br>fun [retryOnConnectionFailure](retry-on-connection-failure.md)(retryOnConnectionFailure: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [OkHttpClient.Builder](index.md)<br>Configure this client to retry or not when a connectivity problem is encountered. By default, this client silently recovers from the following problems: |
| [socketFactory](socket-factory.md) | [jvm]<br>fun [socketFactory](socket-factory.md)(socketFactory: [SocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html)): [OkHttpClient.Builder](index.md)<br>Sets the socket factory used to create connections. OkHttp only uses the parameterless [SocketFactory.createSocket](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html#createSocket--) method to create unconnected sockets. Overriding this method, e. g., allows the socket to be bound to a specific local address. |
| [sslSocketFactory](ssl-socket-factory.md) | [jvm]<br>fun [sslSocketFactory](ssl-socket-factory.md)(sslSocketFactory: [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html), trustManager: [X509TrustManager](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/X509TrustManager.html)): [OkHttpClient.Builder](index.md)<br>Sets the socket factory and trust manager used to secure HTTPS connections. If unset, the system defaults will be used. |
| [writeTimeout](write-timeout.md) | [jvm]<br>@IgnoreJRERequirement<br>fun [writeTimeout](write-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)<br>fun [writeTimeout](write-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)<br>Sets the default write timeout for new connections. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds. |
