//[okhttp-tls](../../../index.md)/[okhttp3.tls](../index.md)/[HandshakeCertificates](index.md)

# HandshakeCertificates

[jvm]\
class [HandshakeCertificates](index.md)

Certificates to identify which peers to trust and also to earn the trust of those peers in kind. Client and server exchange these certificates during the handshake phase of a TLS connection.

###  Server Authentication

This is the most common form of TLS authentication: clients verify that servers are trusted and that they own the hostnames that they represent. Server authentication is required.

To perform server authentication:

- 
   The server's handshake certificates must have a [held certificate](../-held-certificate/index.md) (a     certificate and its private key). The certificate's subject alternative names must match the     server's hostname. The server must also have is a (possibly-empty) chain of intermediate     certificates to establish trust from a root certificate to the server's certificate. The root     certificate is not included in this chain.
- 
   The client's handshake certificates must include a set of trusted root certificates. They will     be used to authenticate the server's certificate chain. Typically this is a set of well-known     root certificates that is distributed with the HTTP client or its platform. It may be     augmented by certificates private to an organization or service.

###  Client Authentication

This is authentication of the client by the server during the TLS handshake. Client authentication is optional.

To perform client authentication:

- 
   The client's handshake certificates must have a [held certificate](../-held-certificate/index.md) (a     certificate and its private key). The client must also have a (possibly-empty) chain of     intermediate certificates to establish trust from a root certificate to the client's     certificate. The root certificate is not included in this chain.
- 
   The server's handshake certificates must include a set of trusted root certificates. They     will be used to authenticate the client's certificate chain. Typically this is not the same     set of root certificates used in server authentication. Instead it will be a small set of     roots private to an organization or service.

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md) |

## Functions

| Name | Summary |
|---|---|
| [sslContext](ssl-context.md) | [jvm]<br>fun [sslContext](ssl-context.md)(): [SSLContext](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLContext.html) |
| [sslSocketFactory](ssl-socket-factory.md) | [jvm]<br>fun [sslSocketFactory](ssl-socket-factory.md)(): [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html) |

## Properties

| Name | Summary |
|---|---|
| [keyManager](key-manager.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;keyManager&quot;)<br>val [keyManager](key-manager.md): [X509KeyManager](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/X509KeyManager.html) |
| [trustManager](trust-manager.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;trustManager&quot;)<br>val [trustManager](trust-manager.md): [X509TrustManager](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/X509TrustManager.html) |
